% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_audio_data.R
\name{bind_audio_data}
\alias{bind_audio_data}
\title{Bind audio data}
\usage{
bind_audio_data(
  .,
  data = NULL,
  url = NULL,
  title = NULL,
  subtitle = NULL,
  filter = NULL,
  url_input_format = NULL,
  url_output_format = NULL,
  subtitle_input_format = NULL,
  subtitle_output_format = NULL,
  title_input_format = NULL,
  title_output_format = NULL,
  filter_input_format = NULL,
  filter_output_format = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{data}{Data.}

\item{url}{Audio URL. The URL of a publicly readable MP3 file. Suggested data type hints: string. Flourish type hint: column}

\item{title}{Audio title. Suggested data type hints: string. Flourish type hint: column}

\item{subtitle}{Audio subtitle. Suggested data type hints: string. Flourish type hint: column}

\item{filter}{Filter. Suggested data type hints: string, number. Flourish type hint: column}

\item{url_input_format}{Formats/parses dates, strings, and numbers for the url column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{url_output_format}{Formats/parses dates, strings, and numbers for the url column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{subtitle_input_format}{Formats/parses dates, strings, and numbers for the subtitle column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{subtitle_output_format}{Formats/parses dates, strings, and numbers for the subtitle column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{title_input_format}{Formats/parses dates, strings, and numbers for the title column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{title_output_format}{Formats/parses dates, strings, and numbers for the title column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{filter_input_format}{Formats/parses dates, strings, and numbers for the filter column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{filter_output_format}{Formats/parses dates, strings, and numbers for the filter column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}
}
\value{
A Flourish chart
}
\description{
Bind audio data
}
\examples{
try(
  flourish(chart_type = "audio", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_audio_data(gapminder)
)
}
