% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variances.R
\name{confInt_sTL}
\alias{confInt_sTL}
\title{Estimated confidence intervals using sTL}
\usage{
confInt_sTL(x1, x2, p, j = 1, alpha = 0.05)
}
\arguments{
\item{x1}{vector or matrix of observations from season 1 (rows: observations, columns: stations).}

\item{x2}{vector or matrix of observations from season 2 (rows: observations, columns: stations).}

\item{p}{a probability.}

\item{j}{quantile and parameter estimation for the jth station (jth column of \code{x}).
Irrelevant if is \code{x1} and \code{x2} are vectors.}

\item{alpha}{confidence level for confidence interval.}
}
\value{
List of \itemize{
\item \code{ci} confidence interval.
\item \code{quant} estimated quantile from a two-component GEV using trimmed L-moments (leftrim=0, rightrim=1).
\item \code{var} variance of the estimated quantile.}
}
\description{
Estimated regional (or local) (1-alpha)-confidence intervals for an estimated
quantile by using seasonal TL(0,1)-moments (sTL).
}
\examples{
library("evd")
# Seasonal observations of 80 years at one station:
x1 <- rgev(80, 2, 1, 0.2) # observations from season 1
x2 <- rgev(80, 3, 1, 0.3) # observations from season 2
confInt_sTL(x1=x1, x2=x2, p=0.95, alpha=0.05)

# Seasonal observations of 100 years at 4 stations:
x1 <- matrix(rgev(400, 2, 1, 0.3), ncol=4)
x2 <- matrix(rgev(400, 4, 1, 0.2), ncol=4)
confInt_sTL(x1=x1, x2=x2, j=2, p=0.95, alpha=0.05)
}

