% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variances.R
\name{confInt_TL}
\alias{confInt_TL}
\title{Estimated confidence intervals using TL}
\usage{
confInt_TL(x, p, j = 1, alpha = 0.05)
}
\arguments{
\item{x}{vector or matrix of annual observations.}

\item{p}{a probability.}

\item{j}{quantile and parameter estimation for the jth station (jth column of \code{x}).
Irrelevant if is \code{x} is a vector.}

\item{alpha}{confidence level for confidence interval.}
}
\value{
List of \itemize{
\item \code{ci} confidence interval.
\item \code{quant} estimated quantile from a GEV using trimmed L-moments (\eqn{leftrim=0, rightrim=1}).}
}
\description{
Estimated regional (or local) (1-alpha)-confidence intervals for an estimated
quantile by using annual TL(0,1)-moments (TL).
}
\examples{
library("evd")
# Seasonal observations of 80 years at one station:
x1 <- rgev(80, 2, 1, 0.2) # observations from season 1
x2 <- rgev(80, 3, 1, 0.3) # observations from season 2
x <- seas2ann(x1, x2) # calculaes annual maxima of the two seasons
confInt_TL(x=x, p=0.95, alpha=0.05)

# Seasonal observations of 100 years at 4 stations:
x1 <- matrix(rgev(400, 2, 1, 0.3), ncol=4) # observations from season 1
x2 <- matrix(rgev(400, 2, 1, 0.2), ncol=4) # observations from season 2
x <- seas2ann(x1, x2) # calculaes annual maxima of the two seasons
confInt_TL(x=x, j=2, p=0.95, alpha=0.05)
}

