% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_flocker_data.R
\name{make_flocker_data_dynamic}
\alias{make_flocker_data_dynamic}
\title{Format data for dynamic (multi-season) occupancy model, to be passed to 
 \code{flock()}.}
\usage{
make_flocker_data_dynamic(
  obs,
  unit_covs = NULL,
  event_covs = NULL,
  quiet = FALSE
)
}
\arguments{
\item{obs}{An I x J x K array where closure is assumed across rows, columns 
are repeated sampling events, and slices along the third dimension are 
seasons. Allowable values are 1 (detection), 0 (no detection), and NA (no 
sampling event).
The data must be formatted so that all NAs are trailing within their rows
across repeat visits, but not necessarily across seasons.}

\item{unit_covs}{A list of dataframes (one per season) of covariates for 
each closure-unit that are constant across repeated sampling events within 
units. All dataframes must have identical column names and types, and all
dataframes must have I rows.}

\item{event_covs}{A named list of I x J x K arrays, each one corresponding to 
a covariate that varies across repeated sampling events within closure-units}

\item{quiet}{Hide progress bars and informational messages?}
}
\value{
A flocker_data list that can be passed as data to \code{flock()}.
}
\description{
Format data for dynamic (multi-season) occupancy model, to be passed to 
 \code{flock()}.
}
