% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{flexiblas-backends}
\alias{flexiblas-backends}
\alias{flexiblas_current_backend}
\alias{flexiblas_list}
\alias{flexiblas_list_loaded}
\alias{flexiblas_load_backend}
\alias{flexiblas_switch}
\title{Handle Backends}
\usage{
flexiblas_current_backend()

flexiblas_list()

flexiblas_list_loaded()

flexiblas_load_backend(name)

flexiblas_switch(n)
}
\arguments{
\item{name}{character vector of backend names or paths (case insensitive).}

\item{n}{loaded backend index.}
}
\value{
\code{flexiblas_current_backend} and \verb{flexiblas_list*} return a character
vector of backend names or paths.

\code{flexiblas_load_backend} and \code{flexiblas_switch} return the indices of
the loaded backends if the operation was successful, or fail otherwise.
}
\description{
Get current backend, list available ones, load and switch between backends.
}
\examples{
\donttest{
n <- 2000
runs <- 10
ignore <- "__FALLBACK__"

A <- matrix(runif(n*n), nrow=n)
B <- matrix(runif(n*n), nrow=n)

# load backends
backends <- setdiff(flexiblas_list(), ignore)
idx <- flexiblas_load_backend(backends)

# benchmark
timings <- sapply(idx, function(i) {
  flexiblas_switch(i)

  # warm-up
  C <- A[1:100, 1:100] \%*\% B[1:100, 1:100]

  unname(system.time({
    for (j in seq_len(runs))
      C <- A \%*\% B
  })[3])
})

if (length(timings)) {
  results <- data.frame(
    backend = backends,
    `timing [s]` = timings,
    `performance [GFlops]` = (2 * (n / 1000)^3) / timings,
    check.names = FALSE)

  results[order(results$performance),]
}
}
}
\seealso{
\link{flexiblas_avail}, \link{flexiblas_version}, \link{flexiblas-threads}
}
