% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_methods.R
\name{ldf}
\alias{ldf}
\alias{ldf.flash}
\alias{ldf.flash_fit}
\title{LDF method for flash and flash fit objects}
\usage{
ldf(object, type)

\method{ldf}{flash}(object, type = "f")

\method{ldf}{flash_fit}(object, type = "f")
}
\arguments{
\item{object}{An object inheriting from class \code{flash} or
\code{flash_fit}.}

\item{type}{Takes identical arguments to function \code{\link[base]{norm}}. Use
\code{"f"} or \code{"2"} for the 2-norm (Euclidean norm); \code{"o"} or
\code{"1"} for the 1-norm (taxicab norm); and \code{"i"} or \code{"m"} for
the infinity norm (maximum norm).}
}
\value{
A list with fields \code{L}, \code{D}, and \code{F}, each of which
  corresponds to one of the matrices in the decomposition \eqn{Y \approx LDF'}
  (with the columns of \eqn{L} and \eqn{F} scaled according to
  argument \code{type}). Note that \code{D} is returned as a vector rather
  than a matrix (the vector of diagonal entries in \eqn{D}). Thus, "fitted
  values" \eqn{LDF'} can be recovered as \code{L \%*\% diag(D) \%*\% t(F)}.
}
\description{
Given a \code{\link{flash}} or \code{\link{flash_fit}} object, returns the LDF
  decomposition \eqn{Y \approx LDF'}.
}
\details{
When the prior families \eqn{G_\ell^{(k)}} and \eqn{G_f^{(k)}} are closed
  under scaling (as is typically the case), then the EBMF model (as
  described in the documention to function \code{\link{flash}}) is only
  identifiable up to scaling by a diagonal matrix \eqn{D}:
  \deqn{Y = LDF' + E.}

Method \code{ldf} scales columns \eqn{\ell_k} and \eqn{f_k}
  so that, depending on the argument to parameter \code{type}, their
  1-norms, 2-norms, or infinity norms are equal to 1.
}
\section{Methods (by class)}{
\itemize{
\item \code{ldf(flash)}: LDF decomposition for \code{\link{flash}} objects

\item \code{ldf(flash_fit)}: LDF decomposition for \code{\link{flash_fit}} objects

}}
