% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_duplicate_rows.R
\name{find_duplicate_rows}
\alias{find_duplicate_rows}
\title{Find duplicate rows in a data frame}
\usage{
find_duplicate_rows(df)
}
\arguments{
\item{df}{A data frame to check for duplicate rows.}
}
\value{
A message stating whether or not duplicate rows were found, and if so, the row numbers of the duplicate and original rows.
}
\description{
This function identifies and reports duplicate rows in a given data frame. It first removes any rows with no values in all cells, and then compares each row to subsequent rows to check for duplicates. Duplicate rows are identified by having the same values in all columns. The function returns a message stating whether or not duplicate rows were found, and if so, the row numbers of the duplicate and original rows.
}
\examples{
# Create example data frame
df <- data.frame(w = c(7, 8, 180, 7), x = c("a", "b", "c", "a"),
                 y = c(4, 5, -6, 4), z = c(7, 8, NA, 7))
# Find duplicate rows
find_duplicate_rows(df)

}
