% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{fixer_time_series}
\alias{fixer_time_series}
\title{Exchange rate time series}
\usage{
fixer_time_series(start_date, end_date, base = "EUR", symbols = NULL)
}
\arguments{
\item{start_date}{The start date of requested time series, in "YYYY-MM-DD"
style, or any style convertable to  "YYYY-MM-DD" using \code{as.Date()}.}

\item{end_date}{The end date of requested time series, in "YYYY-MM-DD"
style, or any style convertable to  "YYYY-MM-DD" using \code{as.Date()}.}

\item{base}{The base currency to index other currencies against. Defaults
to \code{"EUR"}. Other base currencies are only available on paid plans.}

\item{symbols}{A character vector of the symbols of currencies to return
exchange rates for, or a string for a single currency. Defaults to
\code{NULL} and returns all available currencies. See
\code{\link{fixer_symbols}} for details on symbol options.}
}
\value{
A tibble with the exchange rate from the base currency to the given
currency symbols for each date in the requested range.
}
\description{
Time series plans are only available on "professional" and
above plans. The maximum allowed length in a single request is 365 days.

Each currency symbol is displayed in its own column, with a
value relative to the base currency on the given date.

Time series data is only available for "Professional",
"Professional Plus" and "Enterprise" accounts.
}
\examples{
\dontrun{

x <- fixer_time_series(start_date = "2017-04-30", end_date = "2017-06-20",
                       base = "GBP", symbols = c("USD", "EUR"))

}
}
\seealso{
fixer_fluctuation
}
