% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intraday.R
\name{get_intraday_time_series}
\alias{get_intraday_time_series}
\title{Get an intraday time series}
\usage{
get_intraday_time_series(
  resource = c("active-zone-minutes", "calories", "distance", "elevation", "floors",
    "heart", "steps"),
  date,
  detail_level,
  start_time,
  end_time
)
}
\arguments{
\item{resource}{The resource to get}

\item{date}{A date to get data for}

\item{detail_level}{The detail level. One of \code{"1min"}, \code{"5min"}, or \code{"15min"}}

\item{start_time}{The start time of the time window. Default: \code{NULL} gets the whole day}

\item{end_time}{The end time of the time window. Default: \code{NULL} gets the whole day}
}
\value{
A tibble with two columns: \code{time} and \code{{{resource}}}
}
\description{
See the \href{https://dev.fitbit.com/build/reference/web-api/intraday/get-activity-intraday-by-date/}{API documentation} for
more detailed explanations of parameters and more usage information and examples.
}
