% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{concatbatch}
\alias{concatbatch}
\title{Construct the log, models and scores files from a set of batch files}
\usage{
concatbatch(batchfiles)
}
\arguments{
\item{batchfiles}{a vector of batch file names as returned by getBatchFiles}
}
\value{
a list with the concatenated elements: character vectors and/or
data.frames
}
\description{
Get the data saved by fitMarkers in batch files before it
crashed and construct the log, models and score files just as fitMarkers
would have done
}
\details{
all batch files are assumed to contain a list with the same number
of element, each either a character vector or a data.frame. This function
concatenates the elements across the batch files.\cr
This may be useful if fitMarkers has already been running a long time
and then crashed. The partial (or perhaps complete) data can then be
recovered from the saved batch files, so that only the remaining markers
(if any) need to be processed afterwards.
}
