% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guard_basic.R
\name{guard_basic}
\alias{guard_basic}
\title{Basic authentication guard}
\usage{
guard_basic(validate, user_info = NULL, realm = "private", name = "BasicAuth")
}
\arguments{
\item{validate}{A function that will be called with the arguments
\code{username}, \code{password}, \code{realm}, \code{request}, and \code{response} and returns \code{TRUE}
if the user is valid, and \code{FALSE} otherwise. If the function returns a
character vector it is considered to be authenticated and the return value
will be understood as scopes the user is granted.}

\item{user_info}{A function to extract user information from the
username. It is called with a single argument: \code{user} which is the username
used for the successful authentication. The function should return a new
\link[=new_user_info]{user_info} list.}

\item{realm}{The realm this authentication corresponds to. Will be returned
to the client on a failed authentication attempt to inform them of the
credentials required, though most often these days it is kept from the user.}

\item{name}{The name of the guard}
}
\value{
A \link{GuardBasic} R6 object
}
\description{
Basic authentication is a HTTP scheme that sends username and password as a
\code{:} separated, base64 encoded string in the authorization header. Because it
is effectively send in plain text (base64 encoding can easily be decoded)
this should only ever be used along with other security measures such as
https/ssl to avoid username and passwords being snooped from the request.
}
\details{
This guard will use a user-provided function to test a
username/password pair. It is up to the server implementation to handle the
storage and testing of the passwords in a sensible and responsible way. See
\code{\link[sodium:password]{sodium::password_store()}} for a good first step towards responsible design.
}
\section{User information}{
\code{guard_basic()} automatically adds \link[=new_user_info]{user information} after
authentication. By default it will set the \code{provider} field to \code{"local"} and
the \code{id} field to the username used for logging in. Further, it will set
the \code{scopes} field to any scopes returned by the \code{authenticator} function.
}

\examples{
# Create a guard of dubious quality
basic <- guard_basic(
  validate = function(user, password) {
    user == "thomas" && password == "pedersen"
  },
  user_info = function(user) {
    new_user_info(
      name_given = "Thomas",
      name_middle = "Lin",
      name_family = "Pedersen"
    )
  }
)

# Add it to a fireproof plugin
fp <- Fireproof$new()
fp$add_guard(basic, "basic_auth")

# Use it in an endpoint
fp$add_auth("get", "/*", basic_auth)

}
\references{
\href{https://datatracker.ietf.org/doc/html/rfc7617}{Basic authentication RFC}
}
