% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-phone.R
\name{FirebasePhone}
\alias{FirebasePhone}
\title{Phone}
\value{
An object of class \code{FirebasePhone}.
}
\description{
Use mobile phone numbers to authenticate users.
}
\section{Super classes}{
\code{\link[firebase:Firebase]{firebase::Firebase}} -> \code{\link[firebase:FirebaseAuth]{firebase::FirebaseAuth}} -> \code{FirebasePhone}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FirebasePhone-new}{\code{FirebasePhone$new()}}
\item \href{#method-FirebasePhone-verify}{\code{FirebasePhone$verify()}}
\item \href{#method-FirebasePhone-get_recaptcha}{\code{FirebasePhone$get_recaptcha()}}
\item \href{#method-FirebasePhone-confirm}{\code{FirebasePhone$confirm()}}
\item \href{#method-FirebasePhone-get_verification}{\code{FirebasePhone$get_verification()}}
\item \href{#method-FirebasePhone-get_confirmation}{\code{FirebasePhone$get_confirmation()}}
\item \href{#method-FirebasePhone-clone}{\code{FirebasePhone$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="expose_app"><a href='../../firebase/html/Firebase.html#method-Firebase-expose_app'><code>firebase::Firebase$expose_app()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="clear"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-clear'><code>firebase::FirebaseAuth$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="delete_user"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-delete_user'><code>firebase::FirebaseAuth$delete_user()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="expose_auth"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-expose_auth'><code>firebase::FirebaseAuth$expose_auth()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_access_token"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_access_token'><code>firebase::FirebaseAuth$get_access_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_delete_user"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_delete_user'><code>firebase::FirebaseAuth$get_delete_user()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_id_token"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_id_token'><code>firebase::FirebaseAuth$get_id_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_sign_out"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_sign_out'><code>firebase::FirebaseAuth$get_sign_out()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_signed_in"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_signed_in'><code>firebase::FirebaseAuth$get_signed_in()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_signed_up"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_signed_up'><code>firebase::FirebaseAuth$get_signed_up()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="is_signed_in"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-is_signed_in'><code>firebase::FirebaseAuth$is_signed_in()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="print"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-print'><code>firebase::FirebaseAuth$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="req_sign_in"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-req_sign_in'><code>firebase::FirebaseAuth$req_sign_in()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="req_sign_out"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-req_sign_out'><code>firebase::FirebaseAuth$req_sign_out()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="request_id_token"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-request_id_token'><code>firebase::FirebaseAuth$request_id_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="set_language_code"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-set_language_code'><code>firebase::FirebaseAuth$set_language_code()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="sign_out"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-sign_out'><code>firebase::FirebaseAuth$sign_out()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebasePhone-new"></a>}}
\if{latex}{\out{\hypertarget{method-FirebasePhone-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$new(
  persistence = c("session", "local", "memory"),
  config_path = "firebase.rds",
  language_code = NULL,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{persistence}}{How the auth should persit: \code{none}, the user has to sign in at every visit,
\code{session} will only persist in current tab, \code{local} persist even when window is closed.}

\item{\code{config_path}}{Path to the configuration file as created by \code{\link{firebase_config}}.}

\item{\code{language_code}}{Sets the language to use for the UI.
Supported languages are listed \href{https://github.com/firebase/firebaseui-web/blob/master/LANGUAGES.md}{here}.
Set to \code{browser} to use the default browser language of the user.}

\item{\code{session}}{A valid shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialiases Firebase Phone

Initialises the Firebase application client-side.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebasePhone-verify"></a>}}
\if{latex}{\out{\hypertarget{method-FirebasePhone-verify}{}}}
\subsection{Method \code{verify()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$verify(number, id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{number}}{Phone number of the user.}

\item{\code{id}}{Id of the button that triggers verification.
If this is \code{NULL} the user has to go through the recaptcha,
if not \code{NULL} is invisible.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Verify a phhone number
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebasePhone-get_recaptcha"></a>}}
\if{latex}{\out{\hypertarget{method-FirebasePhone-get_recaptcha}{}}}
\subsection{Method \code{get_recaptcha()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$get_recaptcha()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Results from the recaptcha
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebasePhone-confirm"></a>}}
\if{latex}{\out{\hypertarget{method-FirebasePhone-confirm}{}}}
\subsection{Method \code{confirm()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$confirm(code)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{Confirmation code received by the user.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Confirm a code
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebasePhone-get_verification"></a>}}
\if{latex}{\out{\hypertarget{method-FirebasePhone-get_verification}{}}}
\subsection{Method \code{get_verification()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$get_verification()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get Verification
}

\subsection{Returns}{
A list with a boolean (\code{success}) indicating
whether the operation was successful and a \code{response}
contianing the response from Firebase.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebasePhone-get_confirmation"></a>}}
\if{latex}{\out{\hypertarget{method-FirebasePhone-get_confirmation}{}}}
\subsection{Method \code{get_confirmation()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$get_confirmation()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get Confirmation
}

\subsection{Returns}{
A list with a boolean (\code{success}) indicating
whether the operation was successful and a \code{response}
contianing the response from Firebase.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebasePhone-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FirebasePhone-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebasePhone$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
