# firebase.auth.rest

<!-- badges: start -->
[![R-CMD-check](https://github.com/kennedymwavu/firebase.auth.rest/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/kennedymwavu/firebase.auth.rest/actions/workflows/R-CMD-check.yaml)
[![CRAN status](https://www.r-pkg.org/badges/version/firebase.auth.rest)](https://CRAN.R-project.org/package=firebase.auth.rest)
[![Lifecycle: stable](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
<!-- badges: end -->

R wrapper for [Firebase Authentication REST API](https://firebase.google.com/docs/reference/rest/auth).

Designed to be used on the backend of your R applications & APIs.

`{firebase.auth.rest}` enables you to integrate Firebase Authentication services
seamlessly into your projects, allowing for user authentication, account
management, and other authentication-related tasks.

Suitable if you need **absolute full control** on how you build &
customize your login & registration process/pages, while still using Firebase
Auth.

# Installation

Get the stable version from CRAN with:

```r
install.packages("firebase.auth.rest")
```

You can install the development version from GitHub like so:

``` r
remotes::install_github("kennedymwavu/firebase.auth.rest")
```

# Usage

1. Create a [Firebase project](https://console.firebase.google.com/).
2. Grab the project's API key and place it in your `.Renviron` as `FIREBASE_API_KEY`:

    ```r
    FIREBASE_API_KEY = Your-API-Key-Goes-Here
    ```

3. Restart your R session.
4. Connect to your frontend.

Functions in the package are named similarly to the descriptions in the
[Firebase Authentication REST API](https://firebase.google.com/docs/reference/rest/auth)
docs.

These are the exported ones:

- `sign_up()`: Sign up user with email/password.
- `send_email_verification()`: Send email verification.
- `sign_in()`: Sign in a user with email & password.
- `sign_in_anonymously()`: Sign in a user anonymously.
- `send_password_reset_email()`: Send password reset email.
- `change_email()`: Change user email.
- `change_password()`: Change user password.
- `update_profile()`: Update user profile.
- `delete_account()`: Delete user account.
- `get_user_data()`: Get user data from firebase.
- `exchange_custom_token()`: Exchange custom token for an ID and refresh token.
- `exchange_refresh_token()`: Exchange a refresh token for an ID token.

# Related projects

- [{firebase}](https://github.com/JohnCoene/firebase)
- [{polished}](https://github.com/Tychobra/polished)
