% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refine_metadata.R
\name{refine_metadata}
\alias{refine_metadata}
\title{Refine Finna Metadata}
\usage{
refine_metadata(data)
}
\arguments{
\item{data}{A tibble containing raw Finna metadata.}
}
\value{
A tibble with selected, cleaned metadata fields, or NULL if required fields are missing.
}
\description{
The \code{refine_metadata} function cleans and standardizes Finna metadata by:
\itemize{
\item \strong{Validating Required Fields:} Checks for the presence of key metadata fields and returns \code{NULL} if any are missing.
\item \strong{Handling Missing Values:} Replaces \code{NA} values in critical fields with descriptive placeholder text (e.g., "Unknown Title").
\item \strong{Selecting Relevant Fields:} Keeps only the following fields for streamlined analysis:
\itemize{
\item \code{Title}: The title of the resource.
\item \code{Author}: The creator or author of the resource.
\item \code{Year}: The publication or release year.
\item \code{Language}: The language of the resource.
\item \code{Formats}: The format(s) of the resource (e.g., Book, Audio).
\item \code{Subjects}: The subject keywords or classifications.
\item \code{Library}: The owning library or institution.
\item \code{Series}: The series or collection the resource belongs to.
}
}
}
\examples{
library(finna)
sibelius_data <- search_finna("sibelius")
refine_metadata(sibelius_data)

}
