% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{show_best_score_dual}
\alias{show_best_score_dual}
\title{Show best score, based on number or proportion of predictors with
optional cutoff value \emph{(singular)}}
\arguments{
\item{x}{A score class object (e.g., \code{score_cor_pearson}).}

\item{...}{Further arguments passed to or from other methods.}

\item{prop_terms}{A numeric value specifying the proportion
of predictors to consider.}

\item{num_terms}{An integer value specifying the number
of predictors to consider.}

\item{cutoff}{A numeric value specifying the cutoff value.}
}
\value{
A tibble of score results.
}
\description{
Show best score, based on number or proportion of predictors with
optional cutoff value \emph{(singular)}
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)

ames_subset <- modeldata::ames |>
  dplyr::select(
    Sale_Price,
    MS_SubClass,
    MS_Zoning,
    Lot_Frontage,
    Lot_Area,
    Street
  )
ames_subset <- ames_subset |>
  dplyr::mutate(Sale_Price = log10(Sale_Price))

ames_aov_pval_res <-
  score_aov_pval |>
  fit(Sale_Price ~ ., data = ames_subset)
ames_aov_pval_res@results

# Show best score
ames_aov_pval_res |> show_best_score_dual(prop_terms = 0.5)
ames_aov_pval_res |> show_best_score_dual(prop_terms = 0.5, cutoff = 130)

ames_aov_pval_res |> show_best_score_dual(num_terms = 2)
ames_aov_pval_res |> show_best_score_dual(num_terms = 2, cutoff = 130)
\dontshow{\}) # examplesIf}
}
