% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-roc_auc.R
\docType{data}
\name{score_roc_auc}
\alias{score_roc_auc}
\title{Scoring via area under the Receiver Operating Characteristic curve (ROC AUC)}
\format{
An object of class \code{filtro::class_score_roc_auc} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.
}
\usage{
score_roc_auc
}
\value{
An S7 object. The primary property of interest is in \code{results}. This
is a data frame of results that is populated by the \code{fit()} method and has
columns:
\itemize{
\item \code{name}: The name of the score (e.g., \code{roc_auc}).
\item \code{score}: The estimates for each predictor.
\item \code{outcome}: The name of the outcome column.
\item \code{predictor}: The names of the predictor inputs.
}

These data are accessed using \code{object@results} (see examples below).
}
\description{
The area under the ROC curves can be used to measure predictor importance.
}
\details{
This objects are used when either:
\itemize{
\item The predictors are numeric and the outcome is a factor/category, or
\item The predictors are factors and the outcome is numeric.
}

In either case, a ROC curve (via \code{\link[pROC:roc]{pROC::roc()}} or \code{\link[pROC:multiclass]{pROC::multiclass.roc()}}) is created
with the proper variable roles, and the area under the ROC curve is computed (via \code{\link[pROC:auc]{pROC::auc()}}).
Values higher than 0.5 (i.e., \code{max(roc_auc, 1 - roc_auc)} > 0.5) are associated with
more important predictors.
\subsection{Estimating the scores}{

In \pkg{filtro}, the \verb{score_*} objects define a scoring method (e.g., data
input requirements, package dependencies, etc). To compute the scores for
a specific data set, the \code{fit()} method is used. The main arguments for
these functions are:

\describe{
\item{\code{object}}{A score class object (e.g., \code{score_cor_pearson}).}
\item{\code{formula}}{A standard R formula with a single outcome on the right-hand side and one or more predictors (or \code{.}) on the left-hand side. The data are processed via \code{\link[stats:model.frame]{stats::model.frame()}}}
\item{\code{data}}{A data frame containing the relevant columns defined by the formula.}
\item{\code{...}}{Further arguments passed to or from other methods.}
\item{\code{case_weights}}{A quantitative vector of case weights that is the same length as the number of rows in \code{data}. The default of \code{NULL} indicates that there are no case weights. NOTE case weights cannot be used when a multiclass ROC is computed.}
}
}

Missing values are removed for each predictor/outcome combination being
scored.

In cases where the underlying computations fail, the scoring proceeds
silently, and a missing value is given for the score.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

# ROC AUC where the numeric predictors are the predictors and
# `class` is the class outcome/response

cells_subset <- modeldata::cells |>
  dplyr::select(
    class,
    angle_ch_1,
    area_ch_1,
    avg_inten_ch_1,
    avg_inten_ch_2,
    avg_inten_ch_3
  )

cells_roc_auc_res <- score_roc_auc |>
  fit(class ~ ., data = cells_subset)
cells_roc_auc_res@results

# ----------------------------------------------------------------------------

# ROC AUC where `Sale_Price` is the numeric predictor and the class predictors
# are the outcomes/responses

ames_subset <- modeldata::ames |>
  dplyr::select(
    Sale_Price,
    MS_SubClass,
    MS_Zoning,
    Lot_Frontage,
    Lot_Area,
    Street
  )
ames_subset <- ames_subset |>
  dplyr::mutate(Sale_Price = log10(Sale_Price))

ames_roc_auc_res <- score_roc_auc |>
  fit(Sale_Price ~ ., data = ames_subset)
ames_roc_auc_res@results
# TODO Add multiclass example
\dontshow{\}) # examplesIf}
}
\seealso{
Other class score metrics: 
\code{\link{score_aov_pval}},
\code{\link{score_cor_pearson}},
\code{\link{score_imp_rf}},
\code{\link{score_info_gain}},
\code{\link{score_xtab_pval_chisq}}
}
\concept{class score metrics}
\keyword{datasets}
