% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-aov.R
\docType{data}
\name{score_aov_pval}
\alias{score_aov_pval}
\alias{score_aov_fstat}
\title{Scoring via analysis of variance hypothesis tests}
\format{
An object of class \code{filtro::class_score_aov} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.

An object of class \code{filtro::class_score_aov} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.
}
\usage{
score_aov_pval

score_aov_fstat
}
\value{
An S7 object. The primary property of interest is in \code{results}. This
is a data frame of results that is populated by the \code{fit()} method and has
columns:
\itemize{
\item \code{name}: The name of the score (e.g., \code{aov_fstat} or \code{aov_pval}).
\item \code{score}: The estimates for each predictor.
\item \code{outcome}: The name of the outcome column.
\item \code{predictor}: The names of the predictor inputs.
}

These data are accessed using \code{object@results} (see examples below).
}
\description{
These two objects can be used to compute importance scores based on Analysis
of Variance techniques.
}
\details{
These objects are used when either:
\itemize{
\item The predictors are numeric and the outcome is a factor/category, or
\item The predictors are factors and the outcome is numeric.
}

In either case, a linear model (via \code{\link[stats:lm]{stats::lm()}}) is created with the proper
variable roles, and the overall p-value for the hypothesis that all means are
equal is computed via the standard F-statistic. The p-value that is returned
is transformed to be \code{-log10(p_value)} so that larger values are associated
with more important predictors.
\subsection{Estimating the scores}{

In \pkg{filtro}, the \verb{score_*} objects define a scoring method (e.g., data
input requirements, package dependencies, etc). To compute the scores for
a specific data set, the \code{fit()} method is used. The main arguments for
these functions are:

\describe{
\item{\code{object}}{A score class object (e.g., \code{score_aov_pval}).}
\item{\code{formula}}{A standard R formula with a single outcome on the right-hand side and one or more predictors (or \code{.}) on the left-hand side. The data are processed via \code{\link[stats:model.frame]{stats::model.frame()}}}
\item{\code{data}}{A data frame containing the relevant columns defined by the formula.}
\item{\code{...}}{Further arguments passed to or from other methods.}
\item{\code{case_weights}}{A quantitative vector of case weights that is the same length as the number of rows in \code{data}. The default of \code{NULL} indicates that there are no case weights.}
}
}

Missing values are removed for each predictor/outcome combination being
scored.

In cases where the underlying computations fail, the scoring proceeds
silently, and a missing value is given for the score.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Analysis of variance where `class` is the class predictor and the numeric
# predictors are the outcomes/responses

cell_data <- modeldata::cells
cell_data$case <- NULL

# ANOVA p-value
cell_p_val_res <-
  score_aov_pval |>
  fit(class ~ ., data = cell_data)
cell_p_val_res@results

# ANOVA raw p-value
natrual_units <- score_aov_pval |> dont_log_pvalues()
cell_pval_natrual_res <-
  natrual_units |>
  fit(class ~ ., data = cell_data)
cell_pval_natrual_res@results

# ANOVA t/F-statistic
cell_t_stat_res <-
  score_aov_fstat |>
  fit(class ~ ., data = cell_data)
cell_t_stat_res@results

# ---------------------------------------------------------------------------
library(dplyr)

# Analysis of variance where `chem_fp_*` are the class predictors and
# `permeability` is the numeric outcome/response

permeability <-
  modeldata::permeability_qsar |>
  # Make the problem a little smaller for time; use 50 predictors
  select(1:51) |>
  # Make the binary predictor columns into factors
  mutate(across(starts_with("chem_fp"), as.factor))

perm_p_val_res <-
  score_aov_pval |>
  fit(permeability ~ ., data = permeability)
perm_p_val_res@results

# Note that some `lm()` calls failed and are given NA score values. For
# example:
table(permeability$chem_fp_0007)

perm_t_stat_res <-
  score_aov_fstat |>
  fit(permeability ~ ., data = permeability)
perm_t_stat_res@results
\dontshow{\}) # examplesIf}
}
\seealso{
Other class score metrics: 
\code{\link{score_cor_pearson}},
\code{\link{score_imp_rf}},
\code{\link{score_info_gain}},
\code{\link{score_roc_auc}},
\code{\link{score_xtab_pval_chisq}}
}
\concept{class score metrics}
\keyword{datasets}
