% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_functions.R
\name{fig_store}
\alias{fig_store}
\alias{fig_store_list}
\alias{fig_store_many}
\title{Store Values}
\usage{
fig_store(key, value)

fig_store_list(l)

fig_store_many(...)
}
\arguments{
\item{key}{A key to store a value for.}

\item{value}{A value to be stored.}

\item{l}{(named list) Names are used as keys for storing their values.}

\item{...}{Named arguments. Names are used as keys for storing argument
values.}
}
\value{
Reference to self. Other methods can be chained after this one.
}
\description{
These functions allow storing values in the global fig instance.
}
\examples{
fig_store("foo", 1)
fig_store("bar", 123)$store("baz", list(1, 2, 3))
fig_store("x.y", "a")
fig_store_list(list(foo = 123, bar = "abc"))
fig_store_many("foo" = 1, "bar" = 2)
fig_store_many("foo.bar.baz" = 1)
fig_store_many("foo" = "a", "baz" = 123)
}
