% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{fft_internal_filters}
\alias{fft_internal_filters}
\alias{.remove_dc}
\alias{.remove_symmetric}
\alias{.split_symmetric}
\title{Remove DC Component and Symmetric Frequencies}
\usage{
.remove_dc(x)

.remove_symmetric(x)

.split_symmetric(x)
}
\arguments{
\item{x}{A \code{fftab} object containing Fourier coefficients and associated metadata.}
}
\value{
A \code{fftab} object with filtered coefficients.
}
\description{
Internal functions to manipulate and filter Fourier coefficients in \code{fftab} objects.
}
\details{
\itemize{
\item \strong{\code{.remove_dc()}}: Filters out rows where all \verb{.dim_*} columns have a value of \code{0}.
\item \strong{\code{.remove_symmetric()}}:
\itemize{
\item For real-valued signals, it filters out redundant, complex-conjugate frequencies.
\item For complex-valued signals, no filtering is applied as symmetry isn't relevant.
}
\item \strong{\code{.split_symmetric()}}: Splits the coefficients into symmetric and asymmetric parts.
}
}
\seealso{
\itemize{
\item \code{\link[dplyr:filter]{dplyr::filter()}}
\item \code{\link[=fftab]{fftab()}}
}
}
\keyword{internal}
