% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_dfs.R
\name{etwfeToFetwfeDf}
\alias{etwfeToFetwfeDf}
\title{Convert data prepared for \code{etwfe::etwfe()} to the format required by
\code{fetwfe()} and \code{fetwfe::etwfe()}}
\usage{
etwfeToFetwfeDf(
  data,
  yvar,
  tvar,
  idvar,
  gvar,
  covars = character(0),
  drop_first_period_treated = TRUE,
  out_names = list(time = "time_var", unit = "unit_var", treatment = "treatment",
    response = "response")
)
}
\arguments{
\item{data}{A long-format data.frame that you could already feed to \code{etwfe()}.}

\item{yvar}{Character. Column name of the outcome (left-hand side in your \code{fml}).}

\item{tvar}{Character. Column name of the time variable that you pass to \code{etwfe()} as \code{tvar}.}

\item{idvar}{Character. Column name of the unit identifier (the variable you would
cluster on, or pass to \code{etwfe(..., ivar = idvar)} if you were using unit FEs).}

\item{gvar}{Character. Column name of the “first treated” cohort variable passed to \code{etwfe()} as \code{gvar}.
Must be \code{0} for never-treated units, or the (strictly positive) first treated period.}

\item{covars}{Character vector of \emph{additional} covariate columns to keep (default \code{character(0)}).}

\item{drop_first_period_treated}{Logical. Should units already treated in the very first
sample period be removed?  (\code{fetwfe()} will drop them internally anyway, but doing it
here keeps the returned dataframe clean.)  Default \code{TRUE}.}

\item{out_names}{Named list giving the column names that the returned dataframe should have.
The default (\code{time}, \code{unit}, \code{treatment}, \code{y}) matches the arguments usually supplied to
\code{fetwfe()}. \strong{Do not change the \emph{names} of this list} – only the \emph{values} – and keep all four.}
}
\value{
A tidy \code{data.frame} with (in this order)
\itemize{
\item \code{time}       integer,
\item \code{unit}       character,
\item \code{treatment}  integer 0/1 absorbing-state dummy,
\item \code{response}   numeric outcome,
\item any covariates requested in \code{covars}.
Ready to pass straight to \code{fetwfe()} or \code{fetwfe::etwfe()}.
}
}
\description{
\code{etwfeToFetwfeDf()} reshapes and renames a panel dataset that is already
formatted for \code{etwfe::etwfe()} (McDermott 2024) so that it can be
passed directly to fetwfe()\code{or}etwfe()\verb{from the}fetwfe` package. In
particular, it
\itemize{
\item creates an \emph{absorbing‑state} treatment dummy that equals 1 from the
first treated period onward* and 0 otherwise,
\item (optionally) drops units that are already treated in the very first
period of the sample (because \code{fetwfe()} removes them internally), and
\item returns a tidy dataframe whose column names match the arguments that
\code{fetwfe()}/\code{etwfe()} expect.
}
}
\examples{
## toy example ---------------------------------------------------------------
\dontrun{
library(did)  # provides the mpdta example dataframe
data(mpdta)

head(mpdta)

tidy_df <- etwfeToFetwfeDf(
  data  = mpdta,
  yvar = "lemp",
  tvar = "year",
  idvar = "countyreal",
  gvar = "first.treat",
  covars = c("lpop"))

head(tidy_df)

}
## Now you can call fetwfe()  ------------------------------------------------
# res <- fetwfe(
#   pdata      = tidy_df,
#   time_var   = "time_var",
#   unit_var   = "unit_var",
#   treatment  = "treatment",
#   response   = "response",
#   covs       = c("lpop"))

}
\references{
McDermott G (2024). \emph{etwfe: Extended Two-Way Fixed Effects}.
doi:10.32614/CRAN.package.etwfe
\doi{10.32614/CRAN.package.etwfe}, R package
version 0.5.0, \url{https://CRAN.R-project.org/package=etwfe}.
}
