% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fermicatsR.R
\docType{data}
\name{FHL2}
\alias{FHL2}
\title{2FHL Catalog (Second Catalog of Hard Fermi-LAT Sources)}
\format{A data frame with 42 variables on 360 sources.}
\source{
\url{http://fermi.gsfc.nasa.gov/ssc/data/access/lat/2FHL/}
}
\usage{
FHL2
}
\description{
The Second Catalog of Hard Fermi-LAT Sources (2FHL).
Ackermann, M. et al., The Astrophysical Journal Supplement Series, 222, 5 (2016).
FITS Filename: gll_psch_v08.fit, released 16 Sept 2015.
}
\section{Fields}{
 
\describe{
\item{Source_Name}{2FHL JHHMM.m+DDMM, constructed according to IAU Specifications for Nomenclature; 
m is decimal minutes of R.A.; in the name R.A. and decl. are truncated at 0.1 decimal minutes and 1' , respectively. A Source_Name ending with "e" indicates an extended source.}
\item{RAJ2000}{Right Ascension, J2000}
\item{DEJ2000}{Declination, J2000} 
\item{GLON}{Galactic longitude, deg.} 
\item{GLAT}{Galactic latitude, deg.} 
\item{Pos_err_68}{Position uncertainty at 68\% confidence level}
\item{TS}{Test Statistic}
\item{Spectral_Index}{Best fit photon number power-law index} 
\item{Unc_Spectral_Index}{1 sigma error on Spectral_Index} 
\item{Intr_Spectral_Index_D11}{Intrinsic spectral index computed using the Dominguez et al. (2011b) EBL model}
\item{Unc_Intr_Spectral_Index_D11}{1 sigma uncertainty on the intrinsic spectral index computed using the Dominguez et al. (2011b) EBL model}
\item{Intr_Spectral_Index_G12}{Intrinsic spectral index computed using the Gilmore et al. (2012) EBL model}
\item{Unc_Intr_Spectral_Index_G12}{1 sigma uncertainty on the intrinsic spectral index computed using the Gilmore et al. (2012) EBL model}
\item{Flux50}{Integral photon flux from 50 GeV to 2 TeV, photon cm^{-2} s^{-1}}
\item{Unc_Flux50}{1 sigma uncertainty on integral flux from 50 GeV to 2 TeV, photon cm^{-2} s^{-1}}
\item{Energy_Flux50}{Energy flux from 50 GeV to 2 TeV, erg cm^{-2} s^{-1}} 
\item{Unc_Energy_Flux50}{1 sigma error on energy flux from 50 GeV to 2 TeV, erg cm^{-2} s^{-1}} 
\item{Flux50_171GeV}{Integral photon flux from 50 to 171 GeV, cm^{-2} s^{-1}}
\item{Unc_Flux50_171GeV.1}{(lower) 1 sigma error on integral photon flux from 50 to 171 GeV, cm^{-2} s^{-1}, set to NaN if 1 sigma interval contains 0} 
\item{Unc_Flux50_171GeV.2}{(upper) 1 sigma error on integral photon flux from 50 to 171 GeV, cm^{-2} s^{-1}} 
\item{Sqrt_TS50_171GeV}{Square root of Test Statistic between 50 and 171 GeV}
\item{Flux171_585GeV}{Integral photon flux from 171 to 585 GeV, cm^{-2} s^{-1}}
\item{Unc_Flux171_585GeV.1}{(lower) 1 sigma error on integral photon flux from 171 to 585 GeV, cm^{-2} s^{-1}, set to NaN if 1 sigma interval contains 0} 
\item{Unc_Flux171_585GeV.2}{(upper) 1 sigma error on integral photon flux from 171 to 585 GeV, cm^{-2} s^{-1}} 
\item{Sqrt_TS171_585GeV}{Square root of Test Statistic between 171 and 585 GeV}
\item{Flux585_2000GeV}{Integral photon flux from 585 GeV to 2 TeV, cm^{-2} s^{-1}}
\item{Unc_Flux585_2000GeV.1}{(lower) 1 sigma error on integral photon flux from 585 GeV to 2 TeV, cm^{-2} s^{-1}, set to NaN if 1 sigma interval contains 0} 
\item{Unc_Flux585_2000GeV.2}{(upper) 1 sigma error on integral photon flux from 585 GeV to 2 TeV, cm^{-2} s^{-1}} 
\item{Sqrt_TS585_2000GeV}{Square root of Test Statistic between 585 GeV and 2 TeV}
\item{Npred}{Predicted number of photons from the source}
\item{HEP_Energy}{Highest photon energy, GeV}
\item{HEP_Prob}{Probability that the HEP is coming from the source, >=0.85}
\item{ROI}{Region of interest number}
\item{ASSOC}{Name of the most likely associated source} 
\item{ASSOC_PROB_BAY}{Probability of association from the Bayesian method}
\item{ASSOC_PROB_LR}{Probability of association from the likelihood ratio method}
\item{CLASS}{Class designation for most likely association. Capital letters indicate firm identifications; 
lower-case letters indicate associations: Pulsar (psr), Pulsar wind nebula (pwn), Supernova remnant (snr), 
Supernova remnant/Pulsar wind nebula (spp), High-mass binary (hmb), Binary (bin), Star-forming region (sfr), 
BL Lac type of blazar (bll), BL Lac type of blazar with prominent galaxy emission (bll-g), FSRQ type of blazar (fsrq), 
Non-blazar active galaxy (agn), Radio galaxy (rdg), Radio galaxy/BL Lac (rdg/bll), Blazar candidate of uncertain type I (bcu I), 
Blazar candidate of uncertain type II (bcu II), Blazar candidate of uncertain type III (bcu III), Normal galaxy, or part (gal), 
Galaxy cluster (galclu), Unassociated source (  ).} 
\item{Redshift}{Redshift (when available) of the most likely associated source}
\item{NuPeak_obs}{Observed Synchrotron peak frequency, Hz}
\item{X3FGL_Name}{Name of the most likely associated source in 3FGL}
\item{X1FHL_Name}{Name of the most likely associated source in the 1FHL}
\item{TeVCat_Name}{Name of the most likely associated source in the TeVCat}
}
}
\keyword{datasets}

