\name{make.fdt}
\alias{make.fdt}
\alias{make.fdt_cat}

\title{
  Frequency distribution table for continuous and categorical variables
}

\description{
  Makes a full fdt from a minimal set of information. \cr
  Useful to reproduce (when the real data vector is not known) a previous fdt.
}

\usage{
make.fdt(f,
         start,
         end,
         right=FALSE)

make.fdt_cat(f,
             categories=NULL,
             sort=TRUE,
             decreasing=TRUE)
}

\arguments{
  \item{f}{a numeric \code{vector} object of frequency.}
  \item{start}{the left value of the interval of the first class.}
  \item{end}{the last value of the interval of the last class.}
  \item{right}{intervals right open (default = \code{FALSE}).}
  \item{categories}{the levels of the categorical variable.}
  \item{sort}{the levels of the categorical variable will be ordered by frequency. The default is \code{TRUE}.}
  \item{decreasing}{if sort argument is \code{TRUE}, the order will be decreasing by default.}
}

\details{ Given the starting and ending values of the continuous variable table 
 or the levels of the categorical variable plus the number of intervals and the 
 absolute frequency values the functions \code{make.fdt} and \code{make.fdt_cat}
 reconstruct whole fdt or fdt_cat table.   
}

\value{
  The function \code{make.fdt} returns a list with the slots:
  \item{table}{a \code{data.frame} storing the \samp{fdt}.}
  \item{breaks}{a \code{vector} of length 4 storing \samp{start}, \samp{end},
    \samp{h} and \samp{right} of the \samp{fdt} generated by this method.}
  The function \code{make.fdt_cat} returns a list whith the slots:
  \item{Category}{the levels of the categorical variable.}
  \item{f}{absolute frequency, \code{numeric}}
  \item{rf}{relative frequency, \code{numeric}}
  \item{rf(\%)}{relative frequency in percentages, \code{numeric}}
  \item{cf}{cumulative frequency; \code{numeric}}
  \item{cf(\%)}{cumulative frequency in percentages, \code{numeric}}
}

\seealso{
  \code{\link[base]{table}} and \code{\link[base]{cut}} provided by \pkg{base} package.
}

\author{
  Faria, J. C. \cr
  Allaman, I. B \cr
  Jelihovschi, E. G.
}


\examples{
# Numeric
# Making one reference fdt
set.seed(33)
x <- rnorm(1e3, 
           20, 
           2)

(ft.r <- fdt(x))

# Making a brand new
(ft.n  <- make.fdt(f=ft.r$table$f,
                   start=13.711,
                   end=27.229))   # Huumm ..., good, but ... Can it be better? 

summary(ft.n,
        format=TRUE,
        pattern='\%.3f')           # Is it nice now?


# Categorical
x <- sample(letters[1:5], 
            1e3, 
            rep=TRUE)

# Making one reference fdt
(ft.r <- fdt_cat(x))

# Making a brand new
(ft.n <- make.fdt_cat(f=ft.r$f,
                      categ=ft.r$Category))
}
