% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_to_srvf.R
\name{f_to_srvf}
\alias{f_to_srvf}
\title{Transformation to SRVF Space}
\usage{
f_to_srvf(f, time)
}
\arguments{
\item{f}{Either a numeric vector of a numeric matrix or a numeric array
specifying the functions that need to be transformed.
\itemize{
\item If a vector, it must be of shape \eqn{M} and it is interpreted as a
single \eqn{1}-dimensional curve observed on a grid of size \eqn{M}.
\item If a matrix, it must be of shape
\eqn{M \times N}. In this case, it is interpreted as a sample of \eqn{N}
curves observed on a grid of size \eqn{M}, unless \eqn{M = 1} in which case
it is interpreted as a single \eqn{1}-dimensional curve observed on a grid
of size \eqn{M}.
}}

\item{time}{A numeric vector of length \eqn{M} specifying the grid on which
the functions are evaluated.}
}
\value{
A numeric array of the same shape as the input array \code{f} storing the
SRVFs of the original curves.
}
\description{
This function transforms functions in \eqn{R^1} from their original functional
space to the SRVF space.
}
\examples{
q <- f_to_srvf(simu_data$f, simu_data$time)
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
May 2011. Registration of functional data using Fisher-Rao metric,
arXiv:1103.3817v2.

Tucker, J. D., Wu, W., Srivastava, A., Generative models for
functional data using phase and amplitude Separation, Computational
Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}
