% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_contexts.R
\name{RandomDistributiveContext}
\alias{RandomDistributiveContext}
\title{Generate a Random Distributive Context}
\usage{
RandomDistributiveContext(n_elements, density = 0.1)
}
\arguments{
\item{n_elements}{Number of elements in the underlying Poset.}

\item{density}{Probability of an order relation \eqn{a \le b}.}
}
\value{
A \code{FormalContext}.
}
\description{
Generates a random formal context that is guaranteed to produce a
\strong{Distributive Concept Lattice}.

It relies on Birkhoff's Representation Theorem: The lattice of order ideals
of a Poset is always distributive. The context is constructed such that
objects and attributes are the elements of the poset, and the incidence
relation is \eqn{g I m \iff \neg(g \ge m)}.
}
