% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc.r
\name{fc}
\alias{fc}
\title{Generalized Function Composition and Partial Function Evaluation}
\usage{
fc(.func, ...)
}
\arguments{
\item{.func}{the function to be modified.}

\item{...}{the function modifiers (see Details).}
}
\value{
A modified function based on the parameters provided.
}
\description{
'fc' is used to modify functions. It can be used to
compose function with specified function parameters and it can be used
to set parameter values (partial function evaluation).
}
\details{
The 'fc' function works by capturing function modifier
expressions in a list, which can be applied to the specified function
via the 'do.call' function.
The function make use of standard R evaluation only. The 'substitute'
function is not used and modifiers expressions must be syntatically valid.
}
\examples{

# Partial function evaluation - a function that returns the first three
# elements of an object.
head3 <- fc(head, n=3)

# Function composition - a function that returns the fifth through the
# 10th element of an object using the head and tail functions.
head_1_to_10 <- fc(head, n=10)
head_5_to_10 <- fc(tail, x=head_1_to_10(x))
head_5_to_10(iris)
}
