% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_types.r
\name{are-bare-type-predicates}
\alias{are-bare-type-predicates}
\alias{are_bare_list}
\alias{are_bare_atomic}
\alias{are_bare_vector}
\alias{are_bare_integer}
\alias{are_bare_double}
\alias{are_bare_complex}
\alias{are_bare_character}
\alias{are_bare_string}
\alias{are_bare_logical}
\alias{are_bare_raw}
\alias{are_bare_bytes}
\alias{are_bare_numeric}
\title{Bare type predicates}
\usage{
are_bare_list(..., .n = NULL, .all = FALSE)

are_bare_atomic(..., .n = NULL, .all = FALSE)

are_bare_vector(..., .n = NULL, .all = FALSE)

are_bare_integer(..., .n = NULL, .all = FALSE)

are_bare_double(..., .n = NULL, .all = FALSE)

are_bare_complex(..., .n = NULL, .all = FALSE)

are_bare_character(..., .n = NULL, .all = FALSE)

are_bare_string(..., .n = NULL, .all = FALSE)

are_bare_logical(..., .n = NULL, .all = FALSE)

are_bare_raw(..., .n = NULL, .all = FALSE)

are_bare_bytes(..., .n = NULL, .all = FALSE)

are_bare_numeric(..., .n = NULL, .all = FALSE)
}
\arguments{
\item{...}{Objects to be tested.}

\item{.n}{Expected lengths of the vectors.}

\item{.all}{Whether to return if all arguments are TRUE.}
}
\value{
Named logical, or unnamed boolean if \code{.all} is \code{TRUE}.
}
\description{
Wrappers around \link[rlang:rlang-package]{rlang} type predicates that
allow multiple objects to be passed. The following documentation is adapted
from the rlang \link[rlang:bare-type-predicates]{documentation}:

These predicates check for a given type but only return \code{TRUE} for
bare R objects. Bare objects have no class attributes. For example,
a data frame is a list, but not a bare list.
\itemize{
\item The predicates for vectors include the \code{.n} argument for
pattern-matching on the vector length.
\item Like \code{are_atomic()} and unlike base R \code{is.atomic()} for R < 4.4.0,
\code{are_bare_atomic()} does not return \code{TRUE} for \code{NULL}. Starting in
R 4.4.0, \code{is.atomic(NULL)} returns FALSE.
\item Unlike base R \code{is.numeric()}, \code{are_bare_double()} only returns
\code{TRUE} for floating point numbers.
}
}
\details{
The optional input of \code{.n} can be given values
that map to the arguments in \code{...}. If a unnamed vector/list, the input must
either be the same length as the number of arguments given to \code{...}, or
length 1: which is then recycled to the number number of arguments
given to \code{...}. Alternatively, a named vector/list can be given, where
the values for matching named elements are passed to the type predicate,
but unmatched names are passed NULL.
}
\examples{
x <- 1
y <- list()
class(y) <- c("my_class", class(y))
z <- mean

are_bare_list(x, y, z, list(1))

# `.all` can be given to test if all inputs
# evaluate to TRUE
are_bare_list(x, y, z, list(1), .all = TRUE)

# scalar inputs to `.n` are recycled to number of inputs
are_bare_list(x, y, z, list(1), .n = 2)

# inputs to `.n` matching the number of inputs
# are applied sequentially
are_bare_list(list(), y, list(1, 2, 3), list(1), .n = c(0, 0, 3, 1))

# named inputs to `.n` are applied to the matching input
# names, with the other inputs being given NULL
x <- list()
are_bare_list(x, y, list(1, 2, 3), list(1), .n = c(x = 5, "list(1)" = 2))
}
\seealso{
\link{are-type-predicates}, \link{are-scalar-type-predicates}
}
