% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{qlikert}
\alias{qlikert}
\title{Likert quantile function}
\usage{
qlikert(p, prob, labels = names(prob))
}
\arguments{
\item{p}{the vector of probabilities}

\item{prob}{a vector of probabilities or counts; if named, the output is a factor}

\item{labels}{a vector of values, defaults to names(prob) or 1:length(prob), if numeric, the output is numeric}
}
\value{
a vector of the quantiles
}
\description{
Likert quantile function
}
\examples{
p <- seq(0, 1, .1)
prob <- c(.1, .2, .4, .2, .1)
qlikert(p, prob)

p <- seq(0, 1, .1)
prob <- c(A = 10, B = 20, C = 30)
qlikert(p, prob)

# specify labels if prob not named and not 1:length(prob)
labels <- -2:2 
p <- seq(0, 1, .1)
prob <- rep(1, length(labels)) # uniform probability
qlikert(p, prob, labels)
}
