% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_fauna.R
\name{select_fauna}
\alias{select_fauna}
\title{Selection of species based on its characteristics and distribution}
\usage{
select_fauna(data, include_subspecies = FALSE, phylum = "all",
                      class = "all", order = "all", family = "all",
                      genus = "all",
                      lifeForm = "all", filter_lifeForm = "in",
                      habitat = "all", filter_habitat = "in",
                      states = "all", filter_states = "in",
                      country = "all", filter_country = "in",
                      origin = "all", taxonomicStatus = "valid")
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_faunabr}} function.}

\item{include_subspecies}{(logical) include subspecies?
Default = FALSE}

\item{phylum}{(character) The phyla for filtering the dataset. It can
be included more than one phylum. Default = "all".}

\item{class}{(character) The classes for filtering the dataset. It can
be included more than one class. Default = "all".}

\item{order}{(character) The orders for filtering the dataset. It can
be included more than one order. Default = "all".}

\item{family}{(character) The families for filtering the dataset. It can
be included more than one family. Default = "all".}

\item{genus}{(character) The genus for filtering the dataset. It can
be included more than one genus. Default = "all".}

\item{lifeForm}{(character) The life forms for filtering the dataset. It can
be included more than one lifeForm. Default = "all"}

\item{filter_lifeForm}{(character) The type of filtering for life forms. It
can be "in", "only", "not_in" and "and". See details for more about this
argument.}

\item{habitat}{(character) The life habitat for filtering the dataset. It can
be included more than one habitat. Default = "all"}

\item{filter_habitat}{(character) The type of filtering for habitat. It
can be "in", "only", "not_in" and "and". See details for more about this
argument.}

\item{states}{(character) The states for filtering the dataset. It can
be included more than one state. Default = "all".}

\item{filter_states}{(character) The type of filtering for states. It
can be "in", "only", "not_in" and "and". See Details for more about this
argument.}

\item{country}{(character) The country or countries with confirmed
occurrences for filtering the dataset. It can be included more than one
country. Default = "all".}

\item{filter_country}{(character) The type of filtering for country. It can
be "in", "only", "not_in" and "and". See details for more about this argument.}

\item{origin}{(character) The origin for filtering the dataset. It can
be "native", "introduced", "cryptogenic", "domesticaded" and "invasora".
Default = "all".}

\item{taxonomicStatus}{(character) The taxonomic status for filtering the
dataset. It can be "valid", "synonym" or "all".
Default = "valid".}
}
\value{
A new dataframe with the filtered species.
}
\description{
select_fauna allows filter species based on its
characteristics and distribution available in Brazilian Fauna
}
\details{
It's possible to choose 4 ways to filter by lifeform, by habitat,
by states and by country:
"in": selects species that have any occurrence of the determined values. It
allows multiple matches. For example, if country = c("brazil", argentina") and
filter_country = "in", it will select all species that occur in Brazil and/or
Argentina, some of which may also occur in other countries.

"only": selects species that have only occurrence of the determined values.
It allows only single matches. For example, if
country = c("brazil", argentina") and filter_country = "in", it will select
all species that occur exclusively in both countries, without any occurrences
in other countries.

"not_in": selects species that don't have occurrence of the determined
values. It allows single and multiple matches. For example,
if country = c("brazil", argentina") and filter_country = "not_in", it will select
all species without occurrences in Brazil and Argentina.

"and": selects species that have occurrence in all determined values. It
allows single and multiple matches. For example,
if country = c("brazil", argentina") and filter_country = "and", it will select
all species that occurs only in both countries,including species that occurs
in other countries too.

To get the complete list of arguments available for phylum, class, order,
family, genus, lifeForm, habitat, states, country and origins, use
the function \code{\link{fauna_attributes}}
}
\examples{
data("fauna_data") #Load data example
#Select endemic and native species of birds (Aves) with confirmed occurrence
#in Brazil or Argentina
aves_br_ar <- select_fauna(data = fauna_data, include_subspecies = FALSE,
                           phylum = "all", class = "Aves",
                           order = "all",
                           family = "all",
                           genus = "all",
                           lifeForm = "all", filter_lifeForm = "in",
                           habitat = "all", filter_habitat = "in",
                           states = "all", filter_states = "in",
                           country = c("BR", "AR"),
                           filter_country = "in",
                           origin = "native",
                           taxonomicStatus = "valid")
}
\references{
Brazilian Zoology Group. Catálogo Taxonômico da Fauna do Brasil. Available at:
https://ipt.jbrj.gov.br/jbrj/resource?r=catalogo_taxonomico_da_fauna_do_brasil
}
