.rqrb0.fast <- function(y, x, w = NULL, G, zeta, m, b0) {
  #' rqrb0.fast
  #'
  #' Algorithm with preprocessing for Rotated Quantile Regression (RQR) for a
  #' grid of quantiles, the rotation obtained with a copula and  initial values
  #' of the beta coefficients (used by Algorithms 3-4).
  #'
  #' @param y = Dependent variable (N x 1)
  #' @param x = Regressors matrix (N x K)
  #' @param w = Sample weights
  #' @param G = Copula conditional on participation (N x Q)
  #' @param zeta =  Conservative estimate of standard error of residuals
  #' @param m =  Parameter to select interval of observations in top and bottom
  #' groups
  #' @param b0 = Initial values of the beta coefficients for all quantiles (K x
  #' Q)
  #'
  #' @return b = Estimated beta coefficients (K x Q)
  
  # Number of observations (N) and regressors (K)
  N <- NROW(x)
  K <- NCOL(x)
  
  # Initialize sample weights
  if (is.null(w)) {
    w <- rep(1, N)
  }
  
  # Number of quantiles
  Q <- NCOL(G)
  
  # Pregenerate matrix to store beta parameters
  b <- matrix(0, nrow = K, ncol = Q)
  
  # Compute beta parameters with preprocessing (steps 1-4)
  for (i1 in 1:Q) {
    b[, i1] <- .rqrtau.fast(y, x, w, G[, i1, drop = FALSE], zeta, m, b0[, i1, drop = FALSE])
  }
  
  return(b)
}
