% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim.r
\name{dim,GRegion-method}
\alias{dim,GRegion-method}
\alias{dim}
\alias{dim3d,missing-method}
\alias{dim3d}
\alias{dim3d,GRegion-method}
\alias{nrow,missing-method}
\alias{nrow}
\alias{nrow,GRegion-method}
\alias{ncol,missing-method}
\alias{ncol}
\alias{ncol,GRegion-method}
\alias{ndepth,missing-method}
\alias{ndepth}
\alias{ndepth,GRegion-method}
\alias{ncell,missing-method}
\alias{ncell}
\alias{ncell,GRegion-method}
\alias{ncell3d,missing-method}
\alias{ncell3d}
\alias{ncell3d,GRegion-method}
\alias{dim,GVector-method}
\alias{nrow,GVector-method}
\alias{ncol,GVector-method}
\alias{nlyr,missing-method}
\alias{nlyr}
\alias{nlyr,GRaster-method}
\title{Number of rows, columns, depths, cells, and layers}
\usage{
\S4method{dim}{GRegion}(x)

\S4method{dim3d}{missing}(x)

\S4method{dim3d}{GRegion}(x)

\S4method{nrow}{missing}(x)

\S4method{nrow}{GRegion}(x)

\S4method{ncol}{missing}(x)

\S4method{ncol}{GRegion}(x)

\S4method{ndepth}{missing}(x)

\S4method{ndepth}{GRegion}(x)

\S4method{ncell}{missing}(x)

\S4method{ncell}{GRegion}(x)

\S4method{ncell3d}{missing}(x)

\S4method{ncell3d}{GRegion}(x)

\S4method{dim}{GVector}(x)

\S4method{nrow}{GVector}(x)

\S4method{ncol}{GVector}(x)

\S4method{nlyr}{missing}(x)

\S4method{nlyr}{GRaster}(x)
}
\arguments{
\item{x}{A \code{GRegion}, \code{GRaster}, \code{GVector}, or missing. If missing, then the dimensions of the currently active "region" are returned (see \code{vignette("regions", package = "fasterRaster")}).}
}
\value{
A numeric value or vector.
}
\description{
For \code{GRegion}s: Number of rows, columns, depths, and cells:
\itemize{
\item \code{dim()}: Rows and columns
\item \code{dim3d()}: Rows, columns, and depths
\item \code{nrow()}: Rows
\item \code{ncol()}: Columns
\item \code{ndepth()}: Depths (for 3-dimensional rasters only)
\item \code{ncell()}: Number of cells (2 dimensions)
\item \code{ncell3d()}: Number of cells (3 dimensions)
}

For \code{GRaster}s: As above, plus number of layers:
\itemize{
\item \code{nlyr()}: Layers (number of "stacked" rasters--different from depths of a raster).
}

For \code{GVector}s: Number of geometries and fields (columns):
\itemize{
\item \code{dim()}: Number of geometries and number of columns in data table
\item \code{nrow()}: Number of geometries
\item \code{ncol()}: Number of columns in data table
}
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Example data
madElev <- fastData("madElev")
madForest2000 <- fastData("madForest2000")
madCoast0 <- fastData("madCoast0")
madRivers <- fastData("madRivers")
madDypsis <- fastData("madDypsis")

### GRaster properties

# convert SpatRasters to GRasters
elev <- fast(madElev)
forest <- fast(madForest2000)

# plot
plot(elev)

dim(elev) # rows, columns, depths, layers
nrow(elev) # rows
ncol(elev) # columns
ndepth(elev) # depths
nlyr(elev) # layers

res(elev) # resolution

ncell(elev) # cells
ncell3d(elev) # cells (3D rasters only)

topology(elev) # number of dimensions
is.2d(elev) # is it 2D?
is.3d(elev) # is it 3D?

minmax(elev) # min/max values

# name of object in GRASS
sources(elev)

# "names" of the object
names(elev)

# coordinate reference system
crs(elev)

# extent (bounding box)
ext(elev)

# data type
datatype(elev)

# assigning
copy <- elev
copy[] <- pi # assign all cells to the value of pi
copy

# concatenating multiple GRasters
rasts <- c(elev, forest)
rasts

# adding a raster "in place"
add(rasts) <- ln(elev)
rasts

# subsetting
rasts[[1]]
rasts[["madForest2000"]]

# assigning
rasts[[4]] <- elev > 500

# number of layers
nlyr(rasts)

# names
names(rasts)
names(rasts) <- c("elev_meters", "forest", "ln_elev", "high_elevation")
rasts

### GVector properties

# convert sf vectors to GVectors
coast <- fast(madCoast4)
rivers <- fast(madRivers)
dypsis <- fast(madDypsis)

# extent
ext(rivers)

W(rivers) # western extent
E(rivers) # eastern extent
S(rivers) # southern extent
N(rivers) # northern extent
top(rivers) # top extent (NA for 2D rasters like this one)
bottom(rivers) # bottom extent (NA for 2D rasters like this one)

# coordinate reference system
crs(rivers)
st_crs(rivers)

# column names and data types
names(coast)
datatype(coast)

# name of object in GRASS
sources(rivers)

# points, lines, or polygons?
geomtype(dypsis)
geomtype(rivers)
geomtype(coast)

is.points(dypsis)
is.points(coast)

is.lines(rivers)
is.lines(dypsis)

is.polygons(coast)
is.polygons(dypsis)

# dimensions
nrow(rivers) # how many spatial features
ncol(rivers) # hay many columns in the data frame

# number of geometries and sub-geometries
ngeom(coast)
nsubgeom(coast)

# 2- or 3D
topology(rivers) # dimensionality
is.2d(elev) # is it 2D?
is.3d(elev) # is it 3D?

# Update values from GRASS
# (Reads values from GRASS... will not appear to do anything in this case)
coast <- update(coast)

### operations on GVectors

# convert to data frame
as.data.frame(rivers)
as.data.table(rivers)

# subsetting
rivers[c(1:2, 5)] # select 3 rows/geometries
rivers[-5:-11] # remove rows/geometries 5 through 11
rivers[ , 1] # column 1
rivers[ , "NAM"] # select column
rivers[["NAM"]] # select column
rivers[1, 2:3] # row/geometry 1 and column 2 and 3
rivers[c(TRUE, FALSE)] # select every other geometry (T/F vector is recycled)
rivers[ , c(TRUE, FALSE)] # select every other column (T/F vector is recycled)

# removing data table
noTable <- dropTable(rivers)
noTable
nrow(rivers)
nrow(noTable)

# Refresh values from GRASS
# (Reads values from GRASS... will not appear to do anything in this case
# since the rivers object is up-to-date):
rivers <- update(rivers)

# Concatenating multiple vectors
rivers2 <- rbind(rivers, rivers)
dim(rivers)
dim(rivers2)

}
}
\seealso{
\code{\link[=ngeom]{ngeom()}}, \code{\link[=nsubgeom]{nsubgeom()}}, \code{\link[=nacell]{nacell()}}, \code{\link[=nonnacell]{nonnacell()}}, \code{\link[terra:dimensions]{terra::dim()}}
}
