% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind.r
\name{colbind,GVector-method}
\alias{colbind,GVector-method}
\alias{colbind}
\title{Add columns to the data table of a GVector}
\usage{
\S4method{colbind}{GVector}(x, ...)
}
\arguments{
\item{x, ...}{The first argument must be a \code{GVector}. Subsequent arguments can be \code{data.frame}s, \code{data.table}s, \code{matrices}, or \code{GVector}s. Only the data tables of subsequent \code{GVector}s are added to the table in \code{x}; the geometries are ignored.}
}
\value{
A \code{GVector}.
}
\description{
\code{colbind()} adds columns to the data table of a \code{GVector}. You can combine multiple a \code{GVector}'s data table with \code{data.frame}s, \code{data.table}s, \code{matrices}, or the data table(s) from other \code{GVector}(s). To combine two \code{GVector}s, see \code{\link[=rbind]{rbind()}}.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Rivers vector
madRivers <- fastData("madRivers")

# Convert sf to a GVector
rivers <- fast(madRivers)

# Convert GVector to data.frame or data.table
as.data.frame(rivers)
as.data.table(rivers)

# Subset rivers vector
rivers1 <- rivers[1:2]
rivers2 <- rivers[10:11]

# Concatenate rivers
riversCombo <- rbind(rivers1, rivers2)
riversCombo

# Add columns
newCol <- data.frame(new = 1:11)
riversCol <- colbind(rivers, newCol)
riversCol

# Remove table
riversCopy <- rivers
riversCopy # has data table
riversCopy <- dropTable(riversCopy)
riversCopy # no data table

# Add a new table
newTable <- data.frame(num = 1:11, letters = letters[1:11])
addTable(riversCopy) <- newTable
riversCopy

}
}
\seealso{
\code{\link[=rbind]{rbind()}}, \code{\link[fasterRaster]{addTable<-}}, \code{\link[=dropTable]{dropTable()}}
}
