% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fancycut.R
\name{fancycut}
\alias{fancycut}
\title{Like \code{cut}, turn a vector of numbers into a factor}
\usage{
fancycut(x, na.bucket = NA, unmatched.bucket = NA, out.as.factor = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector}

\item{na.bucket}{what level should NA values be given?}

\item{unmatched.bucket}{what level should numbers not covered by an interval be given?}

\item{out.as.factor}{default is TRUE
Should the resulting vector be a factor?
If FALSE will return a character vector.}

\item{...}{These take the form \code{tag = value}.
Tags become the bucket names and values the interval definitions.}
}
\description{
Like \code{cut}, turn a vector of numbers into a factor
}
\examples{
fancycut(
  x = -10:10,
  Zero = 0,
  Small = '[0,2)',
  Medium = '[2,5]',
  Large = '(5,10]'
)

# The following examples are from Richie Cotton via
# https://www.rdocumentation.org/packages/fancycut/versions/0.1.1/topics/fancycut

# The tag = value syntax is useful.
x <- seq.int(0, 1, 0.25)
fancycut(x, low = '[0, 0.5]', high = '(0.5, 1]')

# Not all the values have to live in a bucket.
x <- seq.int(0, 1, 0.25)
fancycut(x, low = '(0.2, 0.3]', high = '(0.7, 0.8)')

# You can use unmatched.bucket to deal with these other intervals.
x <- seq.int(0, 1, 0.25)
fancycut(x, low = '(0.2, 0.3]', high = '(0.7, 0.8)', unmatched.bucket = 'other')

# To match a specific value, make the lower and upper bound the same number.
x <- seq.int(0, 1, 0.25)
fancycut(x, low = '[0, 0.5)', half = '[0.5,0.5]', high = '(0.5, 1]')

# To match NA values, use na.bucket.
x2 <- c(seq.int(0, 1, 0.25), NA)
fancycut(x2, low = '[0, 0.5)', high = '[0.5, 1]', na.bucket = 'missing')

}
