% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srh.simple.posthocs.R
\name{srh.simple.posthocs}
\alias{srh.simple.posthocs}
\title{Simple-effects post hoc tables for all possible effects (within-scope)}
\usage{
srh.simple.posthocs(formula, data)
}
\arguments{
\item{formula}{A formula \code{y ~ A + B (+ C ...)} with at least two RHS factors.}

\item{data}{A \code{data.frame} containing the variables in \code{formula}.}
}
\value{
A named \code{list} of \code{data.frame}s. Each element contains the
columns produced by \code{\link{srh.simple.posthoc}} (e.g., \code{Comparison},
\code{Z}, \code{P.unadj}, \code{P.adj}, \code{m.tests}, \code{adj.note}).
Attributes: \code{"call"} and (optionally) \code{"skipped"} with messages.
}
\description{
For a formula \code{y ~ A + B (+ C ...)}, enumerates \strong{all simple-effect
setups} of the form \code{COMPARE(target) | BY(other factors)} and runs
\code{\link{srh.simple.posthoc}} with \code{scope = "within"} for each.
Returns a named list of data frames (one per simple-effect configuration).
}
\details{
For each choice of the comparison factor \code{target} from the RHS, all
non-empty combinations of the remaining factors are treated as conditioning
sets \code{BY}. For each pair \code{(target, BY)} we call
\code{srh.simple.posthoc()} with \code{compare = target} and
\code{scope = "within"}. Effects where the conditioning subset has < 2 levels
of \code{target} are skipped; messages are collected in attribute \code{"skipped"}.

Labels use ASCII: \code{"COMPARE(A) | BY(B x C)"} (plain \code{" x "}).
}
\examples{
data(mimicry, package = "factorH")

# All simple-effect tables for a 2-factor design
tabs2 <- srh.simple.posthocs(liking ~ gender + condition, data = mimicry)
names(tabs2)
# e.g., tabs2[["COMPARE(gender) | BY(condition)"]]

# Three factors: all COMPARE(target) | BY(conditioning) combinations
tabs3 <- srh.simple.posthocs(liking ~ gender + condition + age_cat, data = mimicry)
names(tabs3)
attr(tabs3, "skipped")  # any skipped combos with reasons

}
