% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VIF.R
\name{vif}
\alias{vif}
\title{Factor Model Variance Inflaction Factor Values}
\usage{
vif(
  ffmObj,
  digits = 2,
  isPrint = TRUE,
  isPlot = TRUE,
  lwd = 2,
  stripText.cex = 1,
  axis.cex = 1,
  title = TRUE,
  ...
)
}
\arguments{
\item{ffmObj}{an object of class \code{ffm} produced by \code{fitFfm}}

\item{digits}{an integer indicating the number of decimal places to be used for rounding. Default is 2.}

\item{isPrint}{logical. if \code{TRUE}, the time series of the computed factor model values is printed along with their mean values.
Else, only the mean values are printed. Default is \code{TRUE}.}

\item{isPlot}{logical. if \code{TRUE}, the time series of the output is plotted. Default is \code{TRUE}.}

\item{lwd}{line width relative to the default. Default is 2.}

\item{stripText.cex}{a number indicating the amount by which strip text in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{axis.cex}{a number indicating the amount by which axis in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{title}{logical. This argument is mainly used for the documentation purpose when you need a plot without any title.
If \code{TRUE}, the plots will have the main tiltle. default is \code{TRUE}.}

\item{...}{potentially further arguments passed.}
}
\value{
\code{ffmRsq} returns the sample mean values and plots the time series of corresponding R squared values
                        and the Variance Inflation factors depending on the values of \code{rsq}, \code{rsqAdj} and \code{VIF}.
                        The time series of the output values are also printed if \code{isPrint} is \code{TRUE}
}
\description{
Calculate and plot the Factor Model Variance Inflaction Factor Values for a fitted model.
                 A VIF for a single explanatory variable (style factor) is obtained using the time series of R-squared values obtained from 
                 the regression of that variable against all other explanatory variables.
                 So, at least 2 explanatory variables are required in \code{exposure.vars} of fitted model to find the VIF.
}
\examples{
\donttest{
library(PCRA)
# load data 
data(stocksCRSP)
data(factorsSPGMI)
dateRange <- c("2006-01-31","2010-12-31")
stockItems <-  c("Date", "TickerLast", "CapGroupLast", "Return",
                "Ret13WkBill","MktIndexCRSP","Sector")
                factorItems <- c("BP","Beta60M","PM12M1M")
stocks_factors <- selectCRSPandSPGMI("monthly", dateRange = dateRange, 
stockItems = stockItems, factorItems = factorItems, outputType ="data.table")
                                    

# fit a fundamental factor model with style variables BP and LogMktCap

fundamental_model <- fitFfm(data = stocks_factors, 
                           asset.var = "TickerLast", 
                           ret.var = "Return", 
                           date.var = "Date", 
                           exposure.vars = c("BP", "PM12M1M")
                           )

#Plot and print the time series of VIF values
vif(fundamental_model,isPrint=TRUE)
 }
}
\author{
Avinash Acharya
}
