% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmRsq.R
\name{fmRsq}
\alias{fmRsq}
\title{Factor Model R-Squared and Adj R-Squared Values}
\usage{
fmRsq(
  ffmObj,
  rsq = TRUE,
  rsqAdj = FALSE,
  plt.type = 2,
  digits = 2,
  isPrint = TRUE,
  isPlot = TRUE,
  lwd = 2,
  stripText.cex = 1,
  axis.cex = 1,
  title = TRUE,
  ...
)
}
\arguments{
\item{ffmObj}{an object of class \code{ffm} produced by \code{fitFfm}}

\item{rsq}{logical; if \code{TRUE}, Factor Model R-squared values are computed for the portfolio. Default is \code{TRUE}.}

\item{rsqAdj}{logical; if \code{TRUE}, Adjusted R-squared values are computed for the portfolio. Default is \code{FALSE}.}

\item{plt.type}{a number to indicate the type of plot for plotting Factor Model R-squared/Adj. R-squared values.
1 indicates barplot, 2 indicates time series xy plot. Default is 2.}

\item{digits}{an integer indicating the number of decimal places to be used for rounding. Default is 2.}

\item{isPrint}{logical. if \code{TRUE}, the time series of the computed factor model values is printed along with their mean values.
Else, only the mean values are printed. Default is \code{TRUE}.}

\item{isPlot}{logical. if \code{TRUE}, the time series of the output is plotted. Default is \code{TRUE}.}

\item{lwd}{line width relative to the default. Default is 2.}

\item{stripText.cex}{a number indicating the amount by which strip text in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{axis.cex}{a number indicating the amount by which axis in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{title}{logical. if \code{TRUE}, the plots will have the main tiltle. default is \code{TRUE}.}

\item{...}{potentially further arguments passed.}
}
\value{
\code{fmRsq} returns the sample mean values and plots the time series of corresponding R squared values
                        and the Variance Inflation factors depending on the values of \code{rsq}, \code{rsqAdj} and \code{VIF}.
                        The time series of the output values are also printed if \code{isPrint} is \code{TRUE}
}
\description{
Calcluate and plot the Factor Model R-Squared, Adjusted R-Squared for a portfolio of assets
}
\examples{
\donttest{
#Load the data
# Fundamental Factor Model
library(PCRA)

dateRange <- c("2006-01-31","2010-12-31")
stockItems <-  c("Date", "TickerLast",  "Return","Sector")
factorItems <- c("BP","Beta60M","PM12M1M")
facDatIT <- selectCRSPandSPGMI("monthly",
                               dateRange = dateRange, 
                               stockItems = stockItems, 
                               factorItems = factorItems, 
                               outputType = "data.table")
asset.var="TickerLast" 
ret.var="Return" 
date.var = "Date"
exposure.vars= factorItems
asset.var="TickerLast" 
ret.var="Return" 
date.var = "Date"
spec1 <- specFfm(data = facDatIT,asset.var = asset.var, ret.var = ret.var, 
                date.var = date.var, exposure.vars = exposure.vars,weight.var = NULL,
                 addIntercept = TRUE, rob.stats = FALSE)
# fit a fundamental factor model
mdlFit <- fitFfmDT(spec1)
mdlRes <- extractRegressionStats(spec1,mdlFit)
fit.cross <- convert(SpecObj = spec1,FitObj = mdlFit, RegStatsObj = mdlRes)
#Calculate and plot the portfolio R-squared values
fmRsq(fit.cross)

#Plot and print the time series of Adj R-squared and VIF values
fmRsq(fit.cross, rsqAdj=TRUE, isPrint=TRUE, plt.type = 2)

}

}
\author{
Avinash Acharya and Doug Martin
}
