% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_image.R
\name{prep_image}
\alias{prep_image}
\title{prepare local image}
\usage{
prep_image(img_file)
}
\arguments{
\item{img_file}{Path to an image of file type 'JPG', 'PNG', or 'BMP'.}
}
\value{
The prepared image object.
}
\description{
Prepares a local image for an upload the 'Kairos' API via \code{\link[facerec]{detect}},
\code{\link[facerec]{enroll}}, \code{\link[facerec]{recognize}} and \code{\link[facerec]{verify}}.
}
\examples{
 \donttest{

 facerec_init()

 # download example image
 finn_image <- 'https://upload.wikimedia.org/wikipedia/en/2/2a/Finn-Force_Awakens_\%282015\%29.png'
 temp_img_path <- tempfile(fileext = '.png')
 download.file(finn_image, temp_img_path, mode = 'wb', quiet = TRUE)

 # prepare image
 finn_local <- prep_image(temp_img_path)

 # use prepared image
 faces <- detect(image = finn_local)
 }

}
