% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_text.R
\name{fabric_text}
\alias{fabric_text}
\title{Insert text within canvas element}
\usage{
fabric_text(
  cid,
  cwidth = 800,
  cheight = 600,
  cfill = "#FFFFFF",
  textId,
  text,
  left = 100,
  top = 100,
  fill = "#2F3941",
  angle = 0,
  opacity = 1,
  fontFamily = "Comic Sans",
  fontSize = 40,
  fontStyle = "normal",
  strokecolor = "#282A36",
  strokewidth = 1,
  fontWeight = "normal",
  underline = FALSE,
  linethrough = FALSE,
  overline = FALSE,
  selectable = TRUE,
  shadow = FALSE,
  shadowCol = "#FFFAF0",
  textAlign = "center",
  lineHeight = 1,
  textBackgroundColor = NULL,
  isDrawingMode = FALSE
)
}
\arguments{
\item{cid}{the id of the canvas element}

\item{cwidth}{the width of the canvas element. Defaults to 800}

\item{cheight}{the height of the canvas element. Defaults to 600}

\item{cfill}{the color of the canvas element}

\item{textId}{the id of the text}

\item{text}{the content of the text}

\item{left}{the text's position from the left relative to the canvas element. Defaults to 100}

\item{top}{the text's position from the top relative to the canvas element. Defaults to 100}

\item{fill}{the text's color. Defaults to '#2F3941' (dark shade of cyan-blue)}

\item{angle}{the angle of rotation of the text. Defaults to 0 (no rotation)}

\item{opacity}{text opacity (from 0 to 1). Defaults to 1}

\item{fontFamily}{the font family of the text. Defaults to 'Comic Sans'}

\item{fontSize}{text sizing. Defaults to 40}

\item{fontStyle}{the font style of the text. Either 'normal' or 'italic'}

\item{strokecolor}{the stroke color of the text Defaults to '#282A36' (Very dark grayish blue)}

\item{strokewidth}{the stroke width of the text. Defaults to 1}

\item{fontWeight}{allows the user to make text thicker or thinner. Keywords can be used ('normal', 'bold'), or numbers. Defaults to 'normal'}

\item{underline}{logical. Whether to underline the text or not. Defaults to FALSE}

\item{linethrough}{logical. Whether to insert a line through the text or not. Defaults to FALSE}

\item{overline}{logical. Whether to put a line above the text or not. Defaults to FALSE}

\item{selectable}{logical. If TRUE, the user can modify interactively the image's size, position and rotation. Defaults to TRUE}

\item{shadow}{logical. If TRUE a text shadow will be inserted behind the raw text. Defaults to FALSE}

\item{shadowCol}{the color of the text shadow. Defaults to #FFFAF0 (floral white)}

\item{textAlign}{the alignment of text. Useful when there are line breaks. Defaults to "center"}

\item{lineHeight}{the height of the line breaks.Defaults to 1}

\item{textBackgroundColor}{the background color of the text, defaults to NULL}

\item{isDrawingMode}{logical. If TRUE, the user can draw inside the canvas element.}
}
\value{
a text object within a canvas element
}
\description{
Insert text within canvas element
}
\examples{


if (interactive()) {


ui <- fluidPage(


fabric_text(cid = "can",
         textId = "text",
         text = "But A Hero Is A Guy Who Gives Out The Meat To Everyone Else.",
         cfill = "#DD5347",
         left = 120,
         shadowCol = "blue",
         fontSize = 20,
         fontWeight = "bold",
         lineHeight = 3
         )
)
server <- function(input, output) {}

shinyApp(ui = ui, server = server)

}
}
