% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesMultinomialPrediction.R
\name{bayesMultinomialPrediction}
\alias{bayesMultinomialPrediction}
\title{Obtain a Bayesian prediction interval for categorical data}
\usage{
bayesMultinomialPrediction(
  Y,
  alpha = 0.15,
  gamma = rep(1, length(Y)),
  category_names = 1:length(Y)
)
}
\arguments{
\item{Y}{Observed data vector of length K containing counts of observations from each of the K categories}

\item{alpha}{Prediction mis-coverage rate}

\item{gamma}{Dirichlet prior concentration for the K categories}

\item{category_names}{Category names (optional)}
}
\value{
pred object
}
\description{
This function computes the Bayesian prediction set for a multinomial conjugate family.
}
