#' @title fabPrediction: Compute FAB Conformal Prediction Intervals
#'
#' @description A package for computing and plotting
#' prediction intervals for numerical data or prediction
#' sets for categorical data using prior information. 
#' Empirical Bayes procedures to estimate the prior information
#' from multi-group data are included.
#'
#' @docType package
#' @name fabPrediction
#'
#' 
#' @author Elizabeth Bersson, \cr Maintainer: Elizabeth Bersson <elb75@@duke.edu>
#' 
#' 
#' @references E. Bersson and P.D. Hoff. (2023) Frequentist Prediction Sets for 
#' Species Abundance using Indirect Information. Preprint.
#'
#' E. Bersson and P.D. Hoff. (2023) Optimal Conformal Prediction for Small Areas.
#' Journal of Survey Statistics and Methodology, forthcoming.
#' 
#' 
#' @keywords package prediction
#' @import stats
#' @import graphics
#' @import grDevices
#' 
#' @family pred methods
#' 
NULL