% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Power_Hotelling_T.R
\name{Sum_of_Wishart_df}
\alias{Sum_of_Wishart_df}
\title{The approximate degrees of freedom formula for sum of Wishart.}
\usage{
Sum_of_Wishart_df(total_sample_size, alloc.ratio, sig1, sig2)
}
\arguments{
\item{total_sample_size}{Target sample size, must be a positive integer.}

\item{alloc.ratio}{Allocation of total sample size into the two groups. Must set as a vector of two
positive numbers. For equal allocation it should be put as c(1,1), for non-equal
allocation one can put c(2,1) or c(3,1) etc.}

\item{sig1}{The true (or estimate) of covariance matrix for the first group. Must be symmetric
(\code{is.symmetric(sig1) == TRUE}) and positive definite (\code{chol(sig1)} without an error!).}

\item{sig2}{The true (or estimate) of covariance matrix for the second group. Must be symmetric
(\code{is.symmetric(sig2) == TRUE}) and positive definite (\code{chol(sig2)} without an error!).}
}
\value{
The approximate degrees of freedom.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The approximate degrees of freedom formula for sum of two
independent Wishart random variable
with parameter sig1 and sig2, and degrees of freedom n1-1 and n2-1
where n1 + n2 is equal to the \code{total_sample_size}.

See Koner and Luo (2023) for more details on the formula for degrees of freedom.
}
\examples{

k <- 8
mu1  <- rep(0,k); del  <- 0.4; mu2 <- mu1 + rep(del, k);
sig1 <- diag(k); sig2 <- sig1 + del*toeplitz(c(1,rep(0.5, k-1)))
alt.dist.samples <- Sum_of_Wishart_df(total_sample_size=150,
sig1=sig1, sig2=sig2, alloc.ratio=c(2,1))

}
\seealso{
\code{\link[=Sim_HotellingT_unequal_var]{Sim_HotellingT_unequal_var()}} and \code{\link[=pHotellingT]{pHotellingT()}}.
}
\author{
Salil Koner \cr Maintainer: Salil Koner
\email{salil.koner@duke.edu}
}
