% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saccade_VTI.R
\name{saccade_VTI}
\alias{saccade_VTI}
\title{Velocity threshold identification of saccades}
\usage{
saccade_VTI(data, sample_rate = NULL, threshold = 150, min_dur = 20)
}
\arguments{
\item{data}{A dataframe with raw data (time, x, y, trial) for one participant}

\item{sample_rate}{sample rate of the eye-tracker. If default of NULL, then it will be computed from the timestamp data and the number of samples}

\item{threshold}{velocity threshold (degrees of VA / sec) to be used for identifying saccades}

\item{min_dur}{minimum duration (ms) expected for saccades. This helps to avoid identification of very short saccades occurring at the boundary of velocity threshold}
}
\value{
a data frame giving the saccades found by trial
}
\description{
Use the velocity threshold algorithm from Salvucci & Goldberg (2000) to determine saccadic eye movements.
Returns a summary of the saccades found per trial, including start and end coordinates, timing, duration, mean velocity, and peak velocity.
}
\details{
Analyses data separately for each unique combination of values in \code{pID} and \code{trial}.
}
\examples{
data <- combine_eyes(HCL)
saccade_VTI(data)

}
\references{
Salvucci, D. D., & Goldberg, J. H. (2000). Identifying fixations and saccades in eye-tracking protocols. Proceedings of the Symposium on Eye Tracking Research & Applications - ETRA '00, 71–78.
}
