% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SimData}
\alias{SimData}
\title{A simulated dataset with eye tracking data}
\format{
A data set with 37 rows and 10 variables
\describe{
  \item{fixationIndex}{a unique numerical index for each fixation}
  \item{AOI1}{1 if AOI1 was fixated at that time and 0 otherwise}
  \item{AOI2}{1 if AOI2 was fixated at that time and 0 otherwise}
  \item{AOI3}{1 if AOI3 was fixated at that time and 0 otherwise}
  \item{AOI}{the name of the AOI that was fixated at that time; expected outcome of codePasses}
  \item{xcoord}{the x coordinate of the fixation position; origin top left}
  \item{ycoord}{the y coordinate of the fixation position; origin top left}
  \item{fixTime}{the time duration that the AOI was fixated}
  \item{passes}{the result of codePasses with \code{fix_min = 3}}
  \item{passesReread}{the result of codePasses with  \code{fix_min = 3} and \code{rereading = TRUE}}
  }
}
\usage{
SimData
}
\description{
This data set contains simulated eye tracking data for demonstration purposes.  
It has the correct data structure for use with the package eyeRead. Mind that 
it also contains expected results from functions.
}
\keyword{datasets}
