% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_sum.R
\name{rsums}
\alias{rsums}
\title{Sum matrix rows and assign name to resulting column}
\usage{
rsums(df, col_name = NULL)
}
\arguments{
\item{df}{A matrix with named rows and columns.}

\item{col_name}{String, name to assign to resulting column.}
}
\value{
A column matrix (with rows and column names)
}
\description{
Improved version of \code{rowSums()} for matrix output. The sum of rows is kept
as a column vector with rows names and the resulting column can be
named in the same command.
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
rsums(wio$Y, "Y")
}
