% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhlwb.R
\name{fhlwb}
\alias{fhlwb}
\title{Probability of Life in the Universe}
\usage{
fhlwb(pS, pB, pC, pL, pR, pP, S, V)
}
\arguments{
\item{pS}{the proportion of stellar systems having a star compatible with the occurrence of the considered stage of life.}

\item{pB}{the proportion of these star systems with a rocky body located within its habitable zone.}

\item{pC}{the proportion of rocky bodies compatible with the emergence of life.}

\item{pL}{the probability that life appeared on these bodies.}

\item{pR}{the probability that life reached the considered evolutionary stage on these bodies.}

\item{pP}{the probability of co-existence occurrence of this stage of life on several bodies simultaneously.}

\item{S}{number of stars in the galaxy in billions}

\item{V}{volume of the galaxy in trillions light year cube (ly^3)}
}
\value{
A list with the following values:
 \enumerate{
   \item PL Estimated proportion of star systems hosting life (%).
   \item NL Estimated number of planets life.
   \item DL Average distance between two planets hosting life (in light years).}
}
\description{
The statistical estimates on the probaility of life in the Universe based on the paper of Frederic Foucher, Keyron Hickman-Lewis, Frances Westall and Andre Brack (2017).
}
\examples{
fhlwb(pS=1, pB=1, pC=.22, pL=.17, pR=1, pP=0.9, V=47, S=200)
}
\references{
Foucher, F., Hickman-Lewis, K., Westall, F., & Brack, A. (2017). A statistical approach to illustrate the challenge of astrobiology for public outreach. Life, 7(4). <doi:10.3390/life7040040>
}
