% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_display.R
\name{format_by_mode}
\alias{format_by_mode}
\title{Format a Probability using a Display Mode}
\usage{
format_by_mode(
  mode,
  kind,
  linear_g,
  log_g,
  log_q,
  ci_linear_g,
  ci_log_g,
  ci_log_q,
  digits
)
}
\arguments{
\item{mode}{Character scalar. One of \code{"linear_G"}, \code{"log_G"},
\code{"log_Q"}, \code{"undefined"}.}

\item{kind}{Character scalar. One of \code{"point"}, \code{"lower"},
\code{"upper"}.}

\item{linear_g}{Numeric scalar. Point estimate on the linear scale.}

\item{log_g}{Numeric scalar. \code{log(G)} (natural log). May be non-finite.}

\item{log_q}{Numeric scalar. \code{log(Q)} with \eqn{Q=1-G} (natural log).
May be non-finite.}

\item{ci_linear_g}{Numeric length-2: \code{c(lower, upper)} for \eqn{G}.}

\item{ci_log_g}{Numeric length-2: \code{c(lower_logG, upper_logG)}.}

\item{ci_log_q}{Numeric length-2: \code{c(upper_logQ, lower_logQ)}.}

\item{digits}{Integer. Significant digits for numeric formatting.}
}
\value{
A character scalar formatted for display. Returns \code{"NA"} if the
required value is non-finite or missing.
}
\description{
Format a probability (point estimate or CI bound) according to a chosen
representation mode. Allowed modes are \code{"linear_G"}, \code{"log_G"},
\code{"log_Q"}, and \code{"undefined"}. The function performs no inference;
it only formats the numeric values already computed (linear and log).

Notes on arguments:
\itemize{
\item \code{log_g}, \code{log_q}, \code{ci_log_g}, \code{ci_log_q} are
natural logarithms (from \code{log()} in R).
\item For \code{"log_Q"}: the upper bound for \eqn{G} uses
\code{ci_log_q[1]} and the lower bound uses \code{ci_log_q[2]}.
This ordering reflects that \eqn{Q = 1-G} decreases as \eqn{G} increases.
}
}
\author{
Hiroshi Hakoyama, \email{hiroshi.hakoyama@gmail.com}
}
\keyword{internal}
