% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eDecisionCurve.R
\name{eDecisionCurve}
\alias{eDecisionCurve}
\title{Decision Curve Plot}
\usage{
eDecisionCurve(task, trained_model, splits, seed = 246)
}
\arguments{
\item{task}{mlr3 task object specifying the task details}

\item{trained_model}{mlr3 trained learner (model) object obtained after training}

\item{splits}{mlr3 object defining data splits for train and test sets}

\item{seed}{numeric, seed for reproducibility (default: 246)}
}
\value{
An interactive decision curve plot
}
\description{
Decision curve analysis is a statistical method used in medical research to evaluate and compare the clinical utility of different diagnostic or predictive models. It assesses the net benefit of a model across a range of decision thresholds, aiding in the selection of the most informative and practical approach for guiding clinical decisions.
}
\examples{
library("explainer")
seed <- 246
set.seed(seed)
# Load necessary packages
if (!requireNamespace("mlbench", quietly = TRUE)) stop("mlbench not installed.")
if (!requireNamespace("mlr3learners", quietly = TRUE)) stop("mlr3learners not installed.")
if (!requireNamespace("ranger", quietly = TRUE)) stop("ranger not installed.")
# Load BreastCancer dataset
utils::data("BreastCancer", package = "mlbench")
target_col <- "Class"
positive_class <- "malignant"
mydata <- BreastCancer[, -1]
mydata <- na.omit(mydata)
sex <- sample(
  c("Male", "Female"),
  size = nrow(mydata),
  replace = TRUE
)
mydata$age <- as.numeric(sample(
  seq(18, 60),
  size = nrow(mydata),
  replace = TRUE
))
mydata$sex <- factor(
  sex,
  levels = c("Male", "Female"),
  labels = c(1, 0)
)
maintask <- mlr3::TaskClassif$new(
  id = "my_classification_task",
  backend = mydata,
  target = target_col,
  positive = positive_class
)
splits <- mlr3::partition(maintask)
mylrn <- mlr3::lrn(
  "classif.ranger",
  predict_type = "prob"
)
mylrn$train(maintask, splits$train)
myplot <- eDecisionCurve(
  task = maintask,
  trained_model = mylrn,
  splits = splits,
  seed = seed
)
}
