% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_combo_rules.R
\name{apply_combo_rules}
\alias{apply_combo_rules}
\title{selects item combinations based on defined rules}
\usage{
apply_combo_rules(
  full,
  combo_length = 4:length(full),
  forced_items = NULL,
  rules = NULL,
  ignoreCores = 1
)
}
\arguments{
\item{full}{a numeric vector containing the the source for the
combinations, typically the indices of the items in the referring dataset}

\item{combo_length}{a numeric vector with the allowed lengths of the
selected combinations (scale lengths)}

\item{forced_items}{a numeric vector of items that are forced to occur
in every selected combination}

\item{rules}{a list defining rules for combination selection}

\item{ignoreCores}{number of cpu cores (threads) to be ignored during
parallized processing.}
}
\value{
a list of numeric vectors containing the selected item combinations
 that match the defined rules of forced_items and/or rules.
}
\description{
selects item combinations based on defined rules
}
\examples{
data(ADL)
forced <- c(1)
rules_object <- list() # rules-Object
rules_object[[1]] <- list("min", 1, 8:9)
rules_object[[2]] <- list("min", 1, 14:15)
rules_object[[3]] <- list("max", 2, 2:6)
rules_object[[4]] <- list("forbidden", c(8,9))
final_combos <- apply_combo_rules(combo_length = 5:7,
                                  full=1:length(ADL),
                                   forced_items = forced,
                                   rules= rules_object)
}
