% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_selected_data.R
\name{get_selected_data_boundary}
\alias{get_selected_data_boundary}
\title{Get selected cells boundary from excel table}
\usage{
get_selected_data_boundary(excelObj)
}
\arguments{
\item{excelObj}{the json data retuned from excel table}
}
\description{
This function is used to the boundary points of data selected in excel table
}
\examples{
if(interactive()){
 library(shiny)
 library(excelR)
 shinyApp(
   ui = fluidPage(excelOutput("table")),
   server = function(input, output, session) {
     output$table <-
       renderExcel(excelTable(data = head(iris), getSelectedData = TRUE))
     observeEvent(input$table,{
       print(get_selected_data_boundary(input$table))
     })
   }
 )
}
}
