% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xl.sheet.add.R
\name{xl.sheet.add}
\alias{xl.sheet.add}
\alias{xl.sheet.duplicate}
\alias{xl.sheet.name}
\alias{xl.sheet.visible}
\alias{xl.sheet.hide}
\alias{xl.sheet.show}
\alias{xl.sheets}
\alias{xl.sheet.activate}
\alias{xl.sheet.delete}
\title{Basic operations with worksheets.}
\usage{
xl.sheet.add(xl.sheet.name = NULL, before = NULL)

xl.sheet.duplicate(before = NULL)

xl.sheet.name(xl.sheet.name = NULL)

xl.sheet.visible(xl.sheet)

xl.sheet.hide(xl.sheet = NULL)

xl.sheet.show(xl.sheet)

xl.sheets()

xl.sheet.activate(xl.sheet)

xl.sheet.delete(xl.sheet = NULL)
}
\arguments{
\item{xl.sheet.name}{character. sheet name/new sheet name}

\item{before}{character/numeric. sheet name or sheet number in active
workbook before which new sheet will be added}

\item{xl.sheet}{character/numeric. sheet name or sheet number in active
workbook}
}
\value{
\itemize{
\item \code{xl.sheet.add}/\code{xl.sheet.activate}/\code{xl.sheet.duplicate}
invisibly return name of created/activated/duplicated sheet.
\item \code{xl.sheets} returns vector of sheet names in active workbook.
\item \code{xl.sheet.delete} invisibly returns NULL.
}
}
\description{
Basic operations with worksheets.
}
\details{
\itemize{ 
\item \code{xl.sheet.add} adds new sheet with given name and invisibly 
returns name of this newly added sheet. Added sheet become active. If 
\code{xl.sheet.name} is missing default name will be used. If \code{before}
argument is missing, sheet will be added at the last position. If sheet with
given name already exists error will be generated.
\item \code{xl.sheet.name} rename active sheet. If its argument is missing
then it just return active sheet name.
\item \code{xl.sheet.hide}/\code{xl.sheet.show} hide and show sheet by its
name. \code{xl.sheet.visible} returns current visibility status of the
sheet.
\item \code{xl.sheet.activate} activates sheet with given name/number. If 
sheet with this name doesn't exist error will be generated.
\item \code{xl.sheet.delete} deletes sheet with given
name/number. If name doesn't submitted it delete active sheet.
}
}
\examples{

\dontrun{ 
xl.workbook.add()
sheets = xl.sheets()
xl.sheet.add("Second")
xl.sheet.add("First", before="Second")
for (sheet in sheets) xl.sheet.delete(sheet) # only 'First' and 'Second' exist in workbook now
xl.sheet.activate("Second") #last sheet activated 
xl.sheet.duplicate() # duplicate second sheet
xl.sheet.name() # "Second (2)"
xl.sheet.name("Third") # "Third"

}
}
\seealso{
\code{\link{xl.workbooks}}
}
