% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{response_d1ph}
\alias{response_d1ph}
\title{Generating a response function based on the EWOC Proportional Hazards model}
\usage{
response_d1ph(
  rho,
  mtd,
  theta,
  min_dose,
  max_dose,
  tau,
  distribution,
  shape = NULL
)
}
\arguments{
\item{rho}{a numerical value indicating the true value of the parameter rho.}

\item{mtd}{a numerical value indicating the true value of the parameter mtd.}

\item{theta}{a numerical value defining the proportion of expected patients
to experience a medically unacceptable, dose-limiting toxicity (DLT) if
administered the MTD.}

\item{min_dose}{a numerical value defining the lower bound of the support of
the MTD.}

\item{max_dose}{a numerical value defining the upper bound of the support of
the MTD.}

\item{tau}{a numerical value defining the period of time for a possible
toxicity be observed.}

\item{distribution}{a character establishing the distribution for the time of
events.}

\item{shape}{a numerical value indicating the true value of the parameter shape.
It is only necessary if 'distribution' = "weibull".}
}
\value{
A function with dose as an input and a Binomial variable based on the
parameters as an output.
}
\description{
Generating a response function based on the EWOC Proportional Hazards model
}
\examples{
response_sim <- response_d1ph(rho = 0.05, mtd = 40, theta = 0.33,
                             min_dose = 30, max_dose = 50,
                             tau = 10, distribution = "exponential")
response_sim(40)

}
